/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.solr.filters;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;

public class ConfigureLog4jListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        URL configURL;
        ServletContext ctx = sce.getServletContext();
        String logConfig = ctx.getInitParameter("log4j.configuration");
        if (null == logConfig) {
            logConfig = "log4j.properties";
        }
        try {
            configURL = new File(logConfig).toURI().toURL();
        }
        catch (MalformedURLException e) {
            configURL = Loader.getResource((String)logConfig);
        }
        if (null == configURL) {
            ctx.log("Log4J configuration not found.  Left unconfigured.");
            return;
        }
        ctx.log(" In context " + ctx.getContextPath() + ", configuring Log4J from " + configURL.toExternalForm());
        String configuratorName = ctx.getInitParameter("log4j.configuratorClass");
        if (null != configuratorName) {
            Configurator configurator;
            try {
                configurator = (Configurator)Class.forName(configuratorName).newInstance();
            }
            catch (Exception ex) {
                ctx.log("Unable to load custom Log4J configuration class '" + configuratorName + "':  " + ex.getMessage());
                return;
            }
            configurator.doConfigure(configURL, (LoggerRepository)new Hierarchy((Logger)new RootLogger(Level.OFF)));
        } else if (configURL.getFile().endsWith(".xml")) {
            DOMConfigurator.configure((URL)configURL);
        } else {
            PropertyConfigurator.configure((URL)configURL);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

