/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import javax.servlet.Filter;
import org.dspace.app.rest.filter.DSpaceRequestContextFilter;
import org.dspace.app.rest.model.hateoas.DSpaceRelProvider;
import org.dspace.app.rest.utils.ApplicationConfig;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.dspace.app.util.DSpaceContextListener;
import org.dspace.utils.servlet.DSpaceWebappServletFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.RelProvider;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
public class Application
extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @Autowired
    private ApplicationConfig configuration;

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class}).initializers(new ApplicationContextInitializer[]{new DSpaceKernelInitializer()});
    }

    @Bean
    public ServletContextInitializer contextInitializer() {
        return servletContext -> servletContext.setInitParameter("dspace.dir", this.configuration.getDspaceHome());
    }

    @Bean
    @Order(value=2)
    protected DSpaceContextListener dspaceContextListener() {
        return new DSpaceContextListener();
    }

    @Bean
    @Order(value=1)
    protected Filter dspaceWebappServletFilter() {
        return new DSpaceWebappServletFilter();
    }

    @Bean
    @Order(value=2)
    protected Filter dspaceRequestContextFilter() {
        return new DSpaceRequestContextFilter();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    protected RelProvider dspaceRelProvider() {
        return new DSpaceRelProvider();
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ ApplicationConfig access$000(Application x0) {
        return x0.configuration;
    }
}

