/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.RelationshipConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.model.RelationshipRestWrapper;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.RelationshipResourceWrapper;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/relationships"})
public class RelationshipRestController {
    private static final String REGEX_REQUESTMAPPING_LABEL = "/{label:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-]+$+}";
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private RelationshipConverter relationshipConverter;
    @Autowired
    Utils utils;
    @Autowired
    private HalLinkService halLinkService;

    @RequestMapping(method={RequestMethod.GET}, value={"/{label:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-]+$+}"})
    public RelationshipResourceWrapper retrieveByLabel(HttpServletResponse response, HttpServletRequest request, @PathVariable String label, @RequestParam(name="dso", required=false) String dsoId, Pageable pageable) throws Exception {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        List relationshipTypeList = this.relationshipTypeService.findByLeftOrRightLabel(context, label);
        LinkedList relationships = new LinkedList();
        if (StringUtils.isNotBlank((CharSequence)dsoId)) {
            UUID uuid = UUIDUtils.fromString((String)dsoId);
            Item item = (Item)this.itemService.find(context, uuid);
            if (item == null) {
                throw new ResourceNotFoundException("The request DSO with id: " + dsoId + " was not found");
            }
            for (RelationshipType relationshipType : relationshipTypeList) {
                relationships.addAll(this.relationshipService.findByItemAndRelationshipType(context, item, relationshipType));
            }
        } else {
            for (Object relationshipType : relationshipTypeList) {
                relationships.addAll(this.relationshipService.findByRelationshipType(context, (RelationshipType)relationshipType));
            }
        }
        LinkedList<RelationshipRest> relationshipRests = new LinkedList<RelationshipRest>();
        for (Relationship relationship : relationships) {
            relationshipRests.add(this.relationshipConverter.fromModel(relationship));
        }
        RelationshipRestWrapper relationshipRestWrapper = new RelationshipRestWrapper();
        relationshipRestWrapper.setLabel(label);
        relationshipRestWrapper.setDsoId(dsoId);
        relationshipRestWrapper.setRelationshipRestList(relationshipRests);
        RelationshipResourceWrapper relationshipResourceWrapper = new RelationshipResourceWrapper(relationshipRestWrapper, this.utils, Integer.valueOf(relationshipRests.size()), pageable);
        this.halLinkService.addLinks((HALResource)relationshipResourceWrapper, pageable);
        return relationshipResourceWrapper;
    }
}

