/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.GenericDSpaceObjectConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dso"})
public class UUIDLookupRestController
implements InitializingBean {
    public static final String CATEGORY = "dso";
    public static final String ACTION = "find";
    public static final String PARAM = "uuid";
    @Autowired
    private ContentServiceFactory contentServiceFactory;
    private static final Logger log = Logger.getLogger(UUIDLookupRestController.class);
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private GenericDSpaceObjectConverter converter;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link(new UriTemplate("/api/dso/find", new TemplateVariables(new TemplateVariable[]{new TemplateVariable(PARAM, TemplateVariable.VariableType.REQUEST_PARAM)})), CATEGORY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"find"}, params={"uuid"})
    public void getDSObyIdentifier(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="uuid") UUID uuid) throws IOException, SQLException, SearchServiceException {
        Context context = null;
        try {
            context = ContextUtil.obtainContext((ServletRequest)request);
            for (DSpaceObjectService dSpaceObjectService : this.contentServiceFactory.getDSpaceObjectServices()) {
                DSpaceObject dso = dSpaceObjectService.find(context, uuid);
                if (dso == null) continue;
                DSpaceObjectRest dsor = (DSpaceObjectRest)this.converter.convert((Object)dso);
                URI link = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo((Class)dsor.getController(), (Object[])new Object[]{dsor.getCategory(), dsor.getTypePlural()}).slash((Object)dsor.getId())).toUri();
                response.setStatus(302);
                response.sendRedirect(link.toString());
                return;
            }
            response.setStatus(404);
        }
        finally {
            context.abort();
        }
    }
}

