/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.content.DSpaceObject;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DSpaceObjectConverter<M extends DSpaceObject, R extends DSpaceObjectRest>
implements DSpaceConverter<M, R> {
    @Autowired(required=true)
    private MetadataConverter metadataConverter;

    public R fromModel(M obj) {
        DSpaceObjectRest resource = this.newInstance();
        resource.setHandle(obj.getHandle());
        if (obj.getID() != null) {
            resource.setUuid(obj.getID().toString());
        }
        resource.setName(obj.getName());
        resource.setMetadata(this.metadataConverter.convert(obj.getMetadata()));
        return (R)resource;
    }

    public M toModel(R obj) {
        return null;
    }

    public boolean supportsModel(DSpaceObject object) {
        return object != null && object.getClass().equals(this.getModelClass());
    }

    protected abstract R newInstance();

    protected abstract Class<M> getModelClass();
}

