/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.DiscoverFacetsConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.SearchFilterToAppliedFilterConverter;
import org.dspace.app.rest.converter.query.SearchQueryConverter;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SearchResultEntryRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class DiscoverResultConverter {
    private static final Logger log = Logger.getLogger(DiscoverResultConverter.class);
    @Autowired
    private List<IndexableObjectConverter> converters;
    @Autowired
    private DiscoverFacetsConverter facetConverter;
    @Autowired
    private SearchFilterToAppliedFilterConverter searchFilterToAppliedFilterConverter;

    public SearchResultsRest convert(Context context, String query, String dsoType, String configurationName, String scope, List<SearchFilter> searchFilters, Pageable page, DiscoverResult searchResult, DiscoveryConfiguration configuration) {
        SearchResultsRest resultsRest = new SearchResultsRest();
        this.setRequestInformation(context, query, dsoType, configurationName, scope, searchFilters, page, resultsRest);
        this.addSearchResults(searchResult, resultsRest);
        this.addFacetValues(context, searchResult, resultsRest, configuration);
        resultsRest.setTotalNumberOfResults(searchResult.getTotalSearchResults());
        return resultsRest;
    }

    private void addFacetValues(Context context, DiscoverResult searchResult, SearchResultsRest resultsRest, DiscoveryConfiguration configuration) {
        this.facetConverter.addFacetValues(context, searchResult, resultsRest, configuration);
    }

    private void addSearchResults(DiscoverResult searchResult, SearchResultsRest resultsRest) {
        for (IndexableObject dspaceObject : CollectionUtils.emptyIfNull((Collection)searchResult.getIndexableObjects())) {
            SearchResultEntryRest resultEntry = new SearchResultEntryRest();
            resultEntry.setIndexableObject(this.convertDSpaceObject(dspaceObject));
            DiscoverResult.IndexableObjectHighlightResult highlightedResults = searchResult.getHighlightedResults(dspaceObject);
            if (highlightedResults != null && MapUtils.isNotEmpty((Map)highlightedResults.getHighlightResults())) {
                for (Map.Entry metadataHighlight : highlightedResults.getHighlightResults().entrySet()) {
                    resultEntry.addHitHighlights((String)metadataHighlight.getKey(), (List)metadataHighlight.getValue());
                }
            }
            resultsRest.addSearchResult(resultEntry);
        }
    }

    private RestAddressableModel convertDSpaceObject(IndexableObject dspaceObject) {
        for (IndexableObjectConverter converter : this.converters) {
            if (!converter.supportsModel(dspaceObject)) continue;
            return (RestAddressableModel)converter.convert((Object)dspaceObject);
        }
        return null;
    }

    private void setRequestInformation(Context context, String query, String dsoType, String configurationName, String scope, List<SearchFilter> searchFilters, Pageable page, SearchResultsRest resultsRest) {
        resultsRest.setQuery(query);
        resultsRest.setConfiguration(configurationName);
        resultsRest.setDsoType(dsoType);
        resultsRest.setScope(scope);
        if (page != null && page.getSort() != null && page.getSort().iterator().hasNext()) {
            Sort.Order order = (Sort.Order)page.getSort().iterator().next();
            resultsRest.setSort(order.getProperty(), order.getDirection().name());
        }
        SearchQueryConverter searchQueryConverter = new SearchQueryConverter();
        List transformedFilters = searchQueryConverter.convert(searchFilters);
        for (SearchFilter searchFilter : CollectionUtils.emptyIfNull((Collection)transformedFilters)) {
            resultsRest.addAppliedFilter(this.searchFilterToAppliedFilterConverter.convertSearchFilter(context, searchFilter));
        }
    }
}

