/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.converter.RelationshipConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItemConverter
extends DSpaceObjectConverter<Item, ItemRest>
implements IndexableObjectConverter<Item, ItemRest> {
    @Autowired(required=true)
    private CollectionConverter collectionConverter;
    @Autowired(required=true)
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private RequestService requestService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private RelationshipConverter relationshipConverter;
    @Autowired
    private ItemService itemService;
    @Autowired
    private MetadataConverter metadataConverter;
    private static final Logger log = LogManager.getLogger(ItemConverter.class);

    public ItemRest fromModel(Item obj) {
        Collection c;
        ItemRest item = (ItemRest)super.fromModel((DSpaceObject)obj);
        item.setInArchive(obj.isArchived());
        item.setDiscoverable(obj.isDiscoverable());
        item.setWithdrawn(obj.isWithdrawn());
        item.setLastModified(obj.getLastModified());
        try {
            c = obj.getOwningCollection();
            if (c != null) {
                item.setOwningCollection(this.collectionConverter.fromModel(c));
            }
        }
        catch (Exception e) {
            log.error("Error setting owning collection for item" + item.getHandle(), (Throwable)e);
        }
        try {
            c = obj.getTemplateItemOf();
            if (c != null) {
                item.setTemplateItemOf(this.collectionConverter.fromModel(c));
            }
        }
        catch (Exception e) {
            log.error("Error setting template item of for item " + item.getHandle(), (Throwable)e);
        }
        ArrayList<BitstreamRest> bitstreams = new ArrayList<BitstreamRest>();
        for (Bundle bun : obj.getBundles()) {
            for (Bitstream bit : bun.getBitstreams()) {
                BitstreamRest bitrest = this.bitstreamConverter.fromModel(bit);
                bitstreams.add(bitrest);
            }
        }
        item.setBitstreams(bitstreams);
        List relationships = new LinkedList();
        try {
            Context context;
            Request currentRequest = this.requestService.getCurrentRequest();
            if (currentRequest != null) {
                HttpServletRequest request = currentRequest.getHttpServletRequest();
                context = ContextUtil.obtainContext((ServletRequest)request);
            } else {
                context = new Context();
            }
            relationships = this.relationshipService.findByItem(context, obj);
        }
        catch (SQLException e) {
            log.error("Error retrieving relationships for item " + item.getHandle(), (Throwable)e);
        }
        LinkedList<RelationshipRest> relationshipRestList = new LinkedList<RelationshipRest>();
        for (Relationship relationship : relationships) {
            RelationshipRest relationshipRest = this.relationshipConverter.fromModel(relationship);
            relationshipRestList.add(relationshipRest);
        }
        item.setRelationships(relationshipRestList);
        List fullList = new LinkedList();
        fullList = this.itemService.getMetadata(obj, "*", "*", "*", "*", true);
        item.setMetadata(this.metadataConverter.convert(fullList));
        return item;
    }

    public Item toModel(ItemRest obj) {
        return null;
    }

    protected ItemRest newInstance() {
        return new ItemRest();
    }

    protected Class<Item> getModelClass() {
        return Item.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo instanceof Item;
    }
}

