/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.MetadataValueConverter;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class MetadataConverter
implements Converter<List<MetadataValue>, MetadataRest> {
    @Autowired
    private ContentServiceFactory contentServiceFactory;
    @Autowired
    private MetadataValueConverter valueConverter;

    public MetadataRest convert(List<MetadataValue> metadataValueList) {
        HashMap<String, TreeSet<MetadataValueRest>> mapOfSortedSets = new HashMap<String, TreeSet<MetadataValueRest>>();
        for (MetadataValue metadataValue : metadataValueList) {
            String key = metadataValue.getMetadataField().toString('.');
            TreeSet<MetadataValueRest> set = (TreeSet<MetadataValueRest>)mapOfSortedSets.get(key);
            if (set == null) {
                set = new TreeSet<MetadataValueRest>(Comparator.comparingInt(MetadataValueRest::getPlace));
                mapOfSortedSets.put(key, set);
            }
            set.add(this.valueConverter.convert(metadataValue));
        }
        MetadataRest metadataRest = new MetadataRest();
        SortedMap mapOfLists = metadataRest.getMap();
        for (Map.Entry entry : mapOfSortedSets.entrySet()) {
            mapOfLists.put((String)entry.getKey(), ((SortedSet)entry.getValue()).stream().collect(Collectors.toList()));
        }
        return metadataRest;
    }

    public void setMetadata(Context context, DSpaceObject dso, MetadataRest metadataRest) throws SQLException, AuthorizeException {
        DSpaceObjectService dsoService = this.contentServiceFactory.getDSpaceObjectService(dso);
        dsoService.clearMetadata(context, dso, "*", "*", "*", "*");
        for (Map.Entry entry : metadataRest.getMap().entrySet()) {
            String[] seq = ((String)entry.getKey()).split("\\.");
            String schema = seq[0];
            String element = seq[1];
            String qualifier = seq.length == 3 ? seq[2] : null;
            for (MetadataValueRest mvr : (List)entry.getValue()) {
                dsoService.addMetadata(context, dso, schema, element, qualifier, mvr.getLanguage(), mvr.getValue(), mvr.getAuthority(), mvr.getConfidence());
            }
        }
        dsoService.update(context, dso);
    }
}

