/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.BrowseEntryRest;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.model.hateoas.BrowseEntryResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class BrowseEntryHalLinkFactory
extends HalLinkFactory<BrowseEntryResource, RestResourceController> {
    protected void addLinks(BrowseEntryResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        BrowseEntryRest data = (BrowseEntryRest)halResource.getContent();
        if (data != null) {
            BrowseIndexRest bix = data.getBrowseIndex();
            UriComponentsBuilder baseLink = this.uriBuilder((Object)((RestResourceController)this.getMethodOn(new Object[]{bix.getCategory(), bix.getType()})).findRel(null, null, bix.getCategory(), English.plural((String)bix.getType()), (String)((Object)bix.getId()), "items", null, null, null));
            this.addFilterParams(baseLink, data);
            list.add(this.buildLink("items", baseLink.build().toUriString()));
        }
    }

    protected Class<RestResourceController> getControllerClass() {
        return RestResourceController.class;
    }

    protected Class<BrowseEntryResource> getResourceClass() {
        return BrowseEntryResource.class;
    }

    private UriComponentsBuilder addFilterParams(UriComponentsBuilder uriComponentsBuilder, BrowseEntryRest data) {
        UriComponentsBuilder result = data.getAuthority() != null ? uriComponentsBuilder.queryParam("filterValue", new Object[]{data.getAuthority()}) : uriComponentsBuilder.queryParam("filterValue", new Object[]{data.getValue()});
        return result;
    }
}

