/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;

@Component
public class DSpaceResourceHalLinkFactory
extends HalLinkFactory<DSpaceResource, RestResourceController> {
    @Autowired
    private Utils utils;

    protected void addLinks(DSpaceResource halResource, Pageable page, LinkedList<Link> list) throws Exception {
        RestAddressableModel data = halResource.getContent();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors()) {
                Link linkToSubResource;
                Method readMethod = pd.getReadMethod();
                String name = pd.getName();
                if (readMethod == null || "class".equals(name)) continue;
                LinkRest linkAnnotation = (LinkRest)AnnotationUtils.findAnnotation((Method)readMethod, LinkRest.class);
                if (linkAnnotation != null) {
                    if (StringUtils.isNotBlank((CharSequence)linkAnnotation.name())) {
                        name = linkAnnotation.name();
                    }
                    linkToSubResource = this.utils.linkToSubResource(data, name);
                    if (!StringUtils.isBlank((CharSequence)linkAnnotation.method())) continue;
                    Object linkedObject = readMethod.invoke((Object)data, new Object[0]);
                    if (linkedObject instanceof RestAddressableModel && linkAnnotation.linkClass().isAssignableFrom(linkedObject.getClass())) {
                        linkToSubResource = this.utils.linkToSingleResource((RestAddressableModel)linkedObject, name);
                    }
                    if (linkedObject == null && linkAnnotation.optional()) continue;
                    halResource.add(linkToSubResource);
                    continue;
                }
                if (!RestModel.class.isAssignableFrom(readMethod.getReturnType())) continue;
                linkToSubResource = this.utils.linkToSubResource(data, name);
                halResource.add(linkToSubResource);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        halResource.add(this.utils.linkToSingleResource(data, "self"));
    }

    protected Class<RestResourceController> getControllerClass() {
        return RestResourceController.class;
    }

    protected Class<DSpaceResource> getResourceClass() {
        return DSpaceResource.class;
    }
}

