/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.LinksRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;

public abstract class DSpaceResource<T extends RestAddressableModel>
extends HALResource<T> {
    public DSpaceResource(T data, Utils utils, String ... rels) {
        super(data);
        if (data != null) {
            try {
                String name;
                LinksRest links = data.getClass().getDeclaredAnnotation(LinksRest.class);
                if (links != null && rels != null) {
                    List<String> relsList = Arrays.asList(rels);
                    LinkRest[] linkRestArray = links.links();
                    int n = linkRestArray.length;
                    for (int i = 0; i < n; ++i) {
                        String model;
                        LinkRest linkAnnotation = linkRestArray[i];
                        if (!relsList.contains(linkAnnotation.name())) continue;
                        name = linkAnnotation.name();
                        Link linkToSubResource = utils.linkToSubResource(data, name);
                        String apiCategory = data.getCategory();
                        LinkRestRepository linkRepository = utils.getLinkResourceRepository(apiCategory, model = data.getType(), linkAnnotation.name());
                        if (!linkRepository.isEmbeddableRelation(data, linkAnnotation.name())) continue;
                        try {
                            Method[] methods = linkRepository.getClass().getMethods();
                            boolean found = false;
                            for (Method m : methods) {
                                if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)linkAnnotation.method())) continue;
                                Page pageResult = (Page)m.invoke((Object)linkRepository, null, ((BaseObjectRest)data).getId(), null, null);
                                EmbeddedPage ep = new EmbeddedPage(linkToSubResource.getHref(), pageResult, null, name);
                                this.embedded.put(name, ep);
                                found = true;
                            }
                            if (found) continue;
                            throw new RuntimeException("Method for relation " + linkAnnotation.name() + " not found: " + linkAnnotation.method());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    }
                }
                for (PropertyDescriptor pd : Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors()) {
                    Method readMethod = pd.getReadMethod();
                    name = pd.getName();
                    if (readMethod == null || "class".equals(name)) continue;
                    LinkRest linkAnnotation = (LinkRest)AnnotationUtils.findAnnotation((Method)readMethod, LinkRest.class);
                    if (linkAnnotation != null) {
                        if (StringUtils.isNotBlank((CharSequence)linkAnnotation.name())) {
                            name = linkAnnotation.name();
                        }
                        Link linkToSubResource = utils.linkToSubResource(data, name);
                        if (StringUtils.isBlank((CharSequence)linkAnnotation.method())) {
                            Object linkedObject;
                            Object wrapObject = linkedObject = readMethod.invoke(data, new Object[0]);
                            if (linkedObject instanceof RestAddressableModel) {
                                RestAddressableModel linkedRM = (RestAddressableModel)linkedObject;
                                wrapObject = utils.getResourceRepository(linkedRM.getCategory(), linkedRM.getType()).wrapResource(linkedRM, new String[0]);
                            } else if (linkedObject instanceof List) {
                                List linkedRMList = (List)linkedObject;
                                if (linkedRMList.size() > 0) {
                                    DSpaceRestRepository resourceRepository = utils.getResourceRepository(((RestAddressableModel)linkedRMList.get(0)).getCategory(), ((RestAddressableModel)linkedRMList.get(0)).getType());
                                    int pageSize = 20;
                                    PageImpl page = new PageImpl(linkedRMList.subList(0, linkedRMList.size() > pageSize ? pageSize : linkedRMList.size()), (Pageable)new PageRequest(0, pageSize), (long)linkedRMList.size());
                                    wrapObject = new EmbeddedPage(linkToSubResource.getHref(), page.map(x$0 -> resourceRepository.wrapResource(x$0, new String[0])), linkedRMList, name);
                                } else {
                                    PageImpl page = new PageImpl(linkedRMList);
                                    wrapObject = new EmbeddedPage(linkToSubResource.getHref(), (Page)page, linkedRMList, name);
                                }
                            }
                            this.embedded.put(name, wrapObject);
                            continue;
                        }
                        try {
                            String apiCategory = data.getCategory();
                            String model = data.getType();
                            LinkRestRepository linkRepository = utils.getLinkResourceRepository(apiCategory, model, linkAnnotation.name());
                            Method[] methods = linkRepository.getClass().getMethods();
                            boolean found = false;
                            for (Method m : methods) {
                                EmbeddedPage ep;
                                if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)linkAnnotation.method())) continue;
                                if (Page.class.isAssignableFrom(m.getReturnType())) {
                                    Page pageResult = (Page)m.invoke((Object)linkRepository, null, ((BaseObjectRest)data).getId(), null, null);
                                    ep = new EmbeddedPage(linkToSubResource.getHref(), pageResult, null, name);
                                    this.embedded.put(name, ep);
                                } else {
                                    RestAddressableModel object = (RestAddressableModel)m.invoke((Object)linkRepository, null, ((BaseObjectRest)data).getId(), null, null);
                                    ep = linkRepository.wrapResource((Serializable)object, new String[]{linkToSubResource.getHref()});
                                    this.embedded.put(name, ep);
                                }
                                found = true;
                            }
                            if (found) continue;
                            throw new RuntimeException("Method for relation " + linkAnnotation.name() + " not found: " + linkAnnotation.method());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    }
                    if (!RestAddressableModel.class.isAssignableFrom(readMethod.getReturnType())) continue;
                    RestAddressableModel linkedObject = (RestAddressableModel)readMethod.invoke(data, new Object[0]);
                    if (linkedObject != null) {
                        this.embedded.put(name, utils.getResourceRepository(linkedObject.getCategory(), linkedObject.getType()).wrapResource(linkedObject, new String[0]));
                        continue;
                    }
                    this.embedded.put(name, null);
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @JsonUnwrapped
    public T getContent() {
        return (T)((RestAddressableModel)super.getContent());
    }
}

