/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.model.DiscoveryResultsRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.SearchFacetEntryResource;
import org.dspace.app.rest.model.hateoas.annotations.RelNameDSpaceResource;
import org.springframework.data.domain.Pageable;

@RelNameDSpaceResource(value="discover")
public class FacetsResource
extends HALResource<SearchResultsRest> {
    @JsonIgnore
    private List<SearchFacetEntryResource> facetResources = new LinkedList();

    public FacetsResource(SearchResultsRest searchResultsRest, Pageable page) {
        super((Object)searchResultsRest);
        this.embedFacetResults(searchResultsRest, page);
    }

    public List<SearchFacetEntryResource> getFacetResources() {
        return this.facetResources;
    }

    private void embedFacetResults(SearchResultsRest data, Pageable page) {
        int i = 0;
        for (SearchFacetEntryRest searchFacetEntryRest : CollectionUtils.emptyIfNull((Collection)data.getFacets())) {
            if (i < page.getOffset() || i >= page.getOffset() + page.getPageSize()) continue;
            this.facetResources.add(new SearchFacetEntryResource(searchFacetEntryRest, (DiscoveryResultsRest)data));
        }
        this.embedResource("facets", (Collection)this.facetResources);
    }
}

