/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.hateoas.BitstreamResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bitstream")
public class BitstreamRestRepository
extends DSpaceObjectRestRepository<Bitstream, BitstreamRest> {
    private final BitstreamService bs;

    @Autowired
    public BitstreamRestRepository(BitstreamService dsoService, BitstreamConverter dsoConverter) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)new /* Unavailable Anonymous Inner Class!! */);
        this.bs = dsoService;
    }

    @PreAuthorize(value="hasPermission(#id, 'BITSTREAM', 'READ')")
    public BitstreamRest findOne(Context context, UUID id) {
        Bitstream bit = null;
        try {
            bit = this.bs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        try {
            if (bit.isDeleted()) {
                throw new ResourceNotFoundException();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (BitstreamRest)this.dsoConverter.fromModel((DSpaceObject)bit);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<BitstreamRest> findAll(Context context, Pageable pageable) {
        ArrayList<Bitstream> bit = new ArrayList<Bitstream>();
        Iterator it = null;
        int total = 0;
        try {
            total = this.bs.countTotal(context);
            it = this.bs.findAll(context, pageable.getPageSize(), pageable.getOffset());
            while (it.hasNext()) {
                bit.add((Bitstream)it.next());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(bit, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @PreAuthorize(value="hasPermission(#id, 'BITSTREAM', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<BitstreamRest> getDomainClass() {
        return BitstreamRest.class;
    }

    public BitstreamResource wrapResource(BitstreamRest bs, String ... rels) {
        return new BitstreamResource(bs, this.utils, rels);
    }

    protected void delete(Context context, UUID id) throws AuthorizeException {
        Bitstream bit = null;
        try {
            bit = this.bs.find(context, id);
            if (bit.getCommunity() != null | bit.getCollection() != null) {
                throw new UnprocessableEntityException("The bitstream cannot be deleted it is a logo");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.bs.delete(context, (DSpaceObject)bit);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public InputStream retrieve(UUID uuid) {
        InputStream is;
        Context context = this.obtainContext();
        Bitstream bit = null;
        try {
            bit = this.bs.find(context, uuid);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        try {
            is = this.bs.retrieve(context, bit);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        context.abort();
        return is;
    }
}

