/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.hateoas.CommunityResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.app.rest.utils.CommunityRestEqualityUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.community")
public class CommunityRestRepository
extends DSpaceObjectRestRepository<Community, CommunityRest> {
    private final CommunityService cs;
    @Autowired
    CommunityConverter converter;
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    CommunityRestEqualityUtils communityRestEqualityUtils;

    public CommunityRestRepository(CommunityService dsoService, CommunityConverter dsoConverter) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)new /* Unavailable Anonymous Inner Class!! */);
        this.cs = dsoService;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected CommunityRest createAndReturn(Context context) throws AuthorizeException {
        Community community;
        CommunityRest communityRest;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            communityRest = (CommunityRest)mapper.readValue((InputStream)input, CommunityRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body: " + e1.toString());
        }
        try {
            Community parent = null;
            String parentCommunityString = req.getParameter("parent");
            if (StringUtils.isNotBlank((CharSequence)parentCommunityString)) {
                UUID parentCommunityUuid = UUIDUtils.fromString((String)parentCommunityString);
                if (parentCommunityUuid == null) {
                    throw new BadRequestException("The given parent parameter was invalid: " + parentCommunityString);
                }
                parent = (Community)this.cs.find(context, parentCommunityUuid);
                if (parent == null) {
                    throw new UnprocessableEntityException("Parent community for id: " + parentCommunityUuid + " not found");
                }
            }
            community = this.cs.create(parent, context);
            this.cs.update(context, (DSpaceObject)community);
            this.metadataConverter.setMetadata(context, (DSpaceObject)community, communityRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (CommunityRest)this.dsoConverter.convert((Object)community);
    }

    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'READ')")
    public CommunityRest findOne(Context context, UUID id) {
        Community community = null;
        try {
            community = (Community)this.cs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (community == null) {
            return null;
        }
        return (CommunityRest)this.dsoConverter.fromModel((DSpaceObject)community);
    }

    public Page<CommunityRest> findAll(Context context, Pageable pageable) {
        List it = null;
        ArrayList<Community> communities = new ArrayList<Community>();
        int total = 0;
        try {
            total = this.cs.countTotal(context);
            it = this.cs.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
            for (Community c : it) {
                communities.add(c);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(communities, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="top")
    public Page<CommunityRest> findAllTop(Pageable pageable) {
        List topCommunities = null;
        try {
            topCommunities = this.cs.findAllTop(this.obtainContext());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(topCommunities, pageable).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="subCommunities")
    public Page<CommunityRest> findSubCommunities(@Parameter(value="parent", required=true) UUID parentCommunity, Pageable pageable) {
        Context context = this.obtainContext();
        List subCommunities = new ArrayList();
        try {
            Community community = (Community)this.cs.find(context, parentCommunity);
            if (community == null) {
                throw new ResourceNotFoundException("core.community with id: " + parentCommunity + " not found");
            }
            subCommunities = community.getSubcommunities();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(subCommunities, pageable).map((Converter)this.dsoConverter);
        return page;
    }

    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<CommunityRest> getDomainClass() {
        return CommunityRest.class;
    }

    public CommunityResource wrapResource(CommunityRest community, String ... rels) {
        return new CommunityResource(community, this.utils, rels);
    }

    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'WRITE')")
    protected CommunityRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        CommunityRest communityRest;
        try {
            communityRest = (CommunityRest)new ObjectMapper().readValue(jsonNode.toString(), CommunityRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing community json: " + e.getMessage());
        }
        Community community = (Community)this.cs.find(context, id);
        if (community == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        CommunityRest originalCommunityRest = this.converter.fromModel(community);
        if (!this.communityRestEqualityUtils.isCommunityRestEqualWithoutMetadata(originalCommunityRest, communityRest)) {
            throw new UnprocessableEntityException("The given JSON and the original Community differ more than just the metadata");
        }
        this.metadataConverter.setMetadata(context, (DSpaceObject)community, communityRest.getMetadata());
        return this.converter.fromModel(community);
    }

    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Community community = null;
        try {
            community = (Community)this.cs.find(context, id);
            if (community == null) {
                throw new ResourceNotFoundException("core.community with id: " + id + " not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to find Community with id = " + id, e);
        }
        try {
            this.cs.delete(context, (DSpaceObject)community);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Community with id = " + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete community because the logo couldn't be deleted", e);
        }
    }
}

