/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.hateoas.EPersonResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.app.rest.repository.patch.EPersonPatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.eperson")
public class EPersonRestRepository
extends DSpaceObjectRestRepository<EPerson, EPersonRest> {
    @Autowired
    AuthorizeService authorizeService;
    private final EPersonService es;
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    EPersonPatch epersonPatch;

    public EPersonRestRepository(EPersonService dsoService, EPersonConverter dsoConverter, EPersonPatch dsoPatch) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)dsoPatch);
        this.es = dsoService;
    }

    protected EPersonRest createAndReturn(Context context) throws AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        EPersonRest epersonRest = null;
        try {
            epersonRest = (EPersonRest)mapper.readValue((InputStream)req.getInputStream(), EPersonRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("error parsing the body... maybe this is not the right error code");
        }
        EPerson eperson = null;
        try {
            eperson = this.es.create(context);
            eperson.setCanLogIn(epersonRest.isCanLogIn());
            eperson.setRequireCertificate(epersonRest.isRequireCertificate());
            eperson.setEmail(epersonRest.getEmail());
            eperson.setNetid(epersonRest.getNetid());
            if (epersonRest.getPassword() != null) {
                this.es.setPassword(eperson, epersonRest.getPassword());
            }
            this.es.update(context, (DSpaceObject)eperson);
            this.metadataConverter.setMetadata(context, (DSpaceObject)eperson, epersonRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (EPersonRest)this.dsoConverter.convert((Object)eperson);
    }

    @PreAuthorize(value="hasPermission(#id, 'EPERSON', 'READ')")
    public EPersonRest findOne(Context context, UUID id) {
        EPerson eperson = null;
        try {
            eperson = (EPerson)this.es.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (eperson == null) {
            return null;
        }
        return (EPersonRest)this.dsoConverter.fromModel((DSpaceObject)eperson);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<EPersonRest> findAll(Context context, Pageable pageable) {
        List epersons = null;
        int total = 0;
        try {
            if (!this.authorizeService.isAdmin(context)) {
                throw new RESTAuthorizationException("The EPerson collection endpoint is reserved to system administrators");
            }
            total = this.es.countTotal(context);
            epersons = this.es.findAll(context, 1, pageable.getPageSize(), pageable.getOffset());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(epersons, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="byName")
    public Page<EPersonRest> findByName(@Parameter(value="q", required=true) String q, Pageable pageable) {
        List epersons = null;
        int total = 0;
        try {
            Context context = this.obtainContext();
            epersons = this.es.search(context, q, pageable.getOffset(), pageable.getOffset() + pageable.getPageSize());
            total = this.es.searchResultCount(context, q);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(epersons, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="byEmail")
    public EPersonRest findByEmail(@Parameter(value="email", required=true) String email) {
        EPerson eperson = null;
        try {
            Context context = this.obtainContext();
            eperson = this.es.findByEmail(context, email);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (eperson == null) {
            return null;
        }
        return (EPersonRest)this.dsoConverter.fromModel((DSpaceObject)eperson);
    }

    @PreAuthorize(value="hasPermission(#uuid, 'EPERSON', #patch)")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID uuid, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, uuid, patch);
    }

    protected void updateDSpaceObject(EPerson ePerson, EPersonRest ePersonRest) throws AuthorizeException, SQLException {
        super.updateDSpaceObject((DSpaceObject)ePerson, (DSpaceObjectRest)ePersonRest);
        Context context = this.obtainContext();
        if (ePersonRest.getPassword() != null) {
            this.es.setPassword(ePerson, ePersonRest.getPassword());
        }
        if (ePersonRest.isRequireCertificate() != ePerson.getRequireCertificate()) {
            ePerson.setRequireCertificate(ePersonRest.isRequireCertificate());
        }
        if (ePersonRest.isCanLogIn() != ePerson.canLogIn()) {
            ePerson.setCanLogIn(ePersonRest.isCanLogIn());
        }
        if (!Objects.equals(ePersonRest.getEmail(), ePerson.getEmail())) {
            ePerson.setEmail(ePersonRest.getEmail());
        }
        if (!Objects.equals(ePersonRest.getNetid(), ePerson.getNetid())) {
            ePerson.setNetid(ePersonRest.getNetid());
        }
        this.es.update(context, (DSpaceObject)ePerson);
    }

    protected void delete(Context context, UUID id) throws AuthorizeException {
        EPerson eperson = null;
        try {
            eperson = (EPerson)this.es.find(context, id);
            List constraints = this.es.getDeleteConstraints(context, eperson);
            if (constraints != null && constraints.size() > 0) {
                throw new UnprocessableEntityException("The eperson cannot be deleted due to the following constraints: " + StringUtils.join((Iterable)constraints, (String)", "));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.es.delete(context, (DSpaceObject)eperson);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<EPersonRest> getDomainClass() {
        return EPersonRest.class;
    }

    public EPersonResource wrapResource(EPersonRest eperson, String ... rels) {
        return new EPersonResource(eperson, this.utils, rels);
    }
}

