/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.hateoas.ItemResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.app.rest.repository.patch.ItemPatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item")
public class ItemRestRepository
extends DSpaceObjectRestRepository<Item, ItemRest> {
    private static final Logger log = Logger.getLogger(ItemRestRepository.class);
    private final ItemService is;
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    ItemPatch itemPatch;
    @Autowired
    WorkspaceItemService workspaceItemService;
    @Autowired
    ItemService itemService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    InstallItemService installItemService;

    public ItemRestRepository(ItemService dsoService, ItemConverter dsoConverter, ItemPatch dsoPatch) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)dsoPatch);
        this.is = dsoService;
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public ItemRest findOne(Context context, UUID id) {
        Item item = null;
        try {
            item = (Item)this.is.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (item == null) {
            return null;
        }
        return (ItemRest)this.dsoConverter.fromModel((DSpaceObject)item);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ItemRest> findAll(Context context, Pageable pageable) {
        Iterator it = null;
        ArrayList<Item> items = new ArrayList<Item>();
        int total = 0;
        try {
            total = this.is.countTotal(context);
            it = this.is.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
            while (it.hasNext()) {
                Item i = (Item)it.next();
                items.add(i);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(items, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', #patch)")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    protected void updateDSpaceObject(Item item, ItemRest itemRest) throws AuthorizeException, SQLException {
        super.updateDSpaceObject((DSpaceObject)item, (DSpaceObjectRest)itemRest);
        Context context = this.obtainContext();
        if (itemRest.getWithdrawn() != item.isWithdrawn()) {
            if (itemRest.getWithdrawn()) {
                this.is.withdraw(context, item);
            } else {
                this.is.reinstate(context, item);
            }
        }
        if (itemRest.getDiscoverable() != item.isDiscoverable()) {
            item.setDiscoverable(itemRest.getDiscoverable());
            this.is.update(context, (DSpaceObject)item);
        }
    }

    public Class<ItemRest> getDomainClass() {
        return ItemRest.class;
    }

    public ItemResource wrapResource(ItemRest item, String ... rels) {
        return new ItemResource(item, this.utils, rels);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Item item = null;
        try {
            item = (Item)this.is.find(context, id);
            if (item == null) {
                throw new ResourceNotFoundException("core.item with id: " + id + " not found");
            }
            if (this.is.isInProgressSubmission(context, item)) {
                throw new UnprocessableEntityException("The item cannot be deleted. It's part of a in-progress submission.");
            }
            if (item.getTemplateItemOf() != null) {
                throw new UnprocessableEntityException("The item cannot be deleted. It's a template for a collection");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.is.delete(context, (DSpaceObject)item);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected ItemRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        String owningCollectionUuidString = req.getParameter("owningCollection");
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = null;
        try {
            ServletInputStream input = req.getInputStream();
            itemRest = (ItemRest)mapper.readValue((InputStream)input, ItemRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", (Throwable)e1);
        }
        if (!itemRest.getInArchive()) {
            throw new BadRequestException("InArchive attribute should not be set to false for the create");
        }
        UUID owningCollectionUuid = UUIDUtils.fromString((String)owningCollectionUuidString);
        Collection collection = (Collection)this.collectionService.find(context, owningCollectionUuid);
        if (collection == null) {
            throw new BadRequestException("The given owningCollection parameter is invalid: " + owningCollectionUuid);
        }
        WorkspaceItem workspaceItem = this.workspaceItemService.create(context, collection, false);
        Item item = workspaceItem.getItem();
        item.setArchived(true);
        item.setOwningCollection(collection);
        item.setDiscoverable(itemRest.getDiscoverable());
        item.setLastModified(itemRest.getLastModified());
        this.metadataConverter.setMetadata(context, (DSpaceObject)item, itemRest.getMetadata());
        Item itemToReturn = this.installItemService.installItem(context, (InProgressSubmission)workspaceItem);
        return (ItemRest)this.dsoConverter.fromModel((DSpaceObject)itemToReturn);
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'WRITE')")
    protected ItemRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID uuid, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = null;
        try {
            itemRest = (ItemRest)mapper.readValue(jsonNode.toString(), ItemRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", (Throwable)e1);
        }
        Item item = (Item)this.itemService.find(context, uuid);
        if (item == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + uuid + " not found");
        }
        if (!StringUtils.equals((CharSequence)uuid.toString(), (CharSequence)itemRest.getId())) {
            throw new IllegalArgumentException("The UUID in the Json and the UUID in the url do not match: " + uuid + ", " + itemRest.getId());
        }
        this.metadataConverter.setMetadata(context, (DSpaceObject)item, itemRest.getMetadata());
        return (ItemRest)this.dsoConverter.fromModel((DSpaceObject)item);
    }
}

