/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.PoolTaskConverter;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.PoolTaskRest;
import org.dspace.app.rest.model.hateoas.PoolTaskResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="workflow.pooltask")
public class PoolTaskRestRepository
extends DSpaceRestRepository<PoolTaskRest, Integer> {
    private static final Logger log = Logger.getLogger(PoolTaskRestRepository.class);
    @Autowired
    ItemService itemService;
    @Autowired
    EPersonService epersonService;
    @Autowired
    PoolTaskService poolTaskService;
    @Autowired
    PoolTaskConverter converter;
    @Autowired
    XmlWorkflowService workflowService;
    @Autowired
    WorkflowRequirementsService workflowRequirementsService;
    @Autowired
    AuthorizeService authorizeService;

    @PreAuthorize(value="hasPermission(#id, 'POOLTASK', 'READ')")
    public PoolTaskRest findOne(Context context, Integer id) {
        PoolTask task = null;
        try {
            task = (PoolTask)this.poolTaskService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (task == null) {
            return null;
        }
        return this.converter.fromModel(task);
    }

    @SearchRestMethod(name="findByUser")
    public Page<PoolTaskRest> findByUser(@Parameter(value="uuid") UUID userID, Pageable pageable) {
        List tasks = null;
        try {
            Context context = this.obtainContext();
            EPerson currentUser = context.getCurrentUser();
            if (currentUser == null) {
                throw new RESTAuthorizationException("This endpoint is available only to logged-in user to search for their own pool tasks or the admins");
            }
            if (!this.authorizeService.isAdmin(context) && !userID.equals(currentUser.getID())) {
                throw new RESTAuthorizationException("Only administrators can search for pool tasks of other users");
            }
            EPerson ep = (EPerson)this.epersonService.find(context, userID);
            tasks = this.poolTaskService.findByEperson(context, ep);
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(tasks, pageable).map((Converter)this.converter);
        return page;
    }

    public Class<PoolTaskRest> getDomainClass() {
        return PoolTaskRest.class;
    }

    public PoolTaskResource wrapResource(PoolTaskRest task, String ... rels) {
        return new PoolTaskResource(task, this.utils, rels);
    }

    @PreAuthorize(value="hasPermission(#id, 'POOLTASK', 'WRITE')")
    protected PoolTaskRest action(Context context, HttpServletRequest request, Integer id) throws SQLException, IOException {
        PoolTask task = null;
        try {
            task = (PoolTask)this.poolTaskService.find(context, id.intValue());
            if (task == null) {
                throw new ResourceNotFoundException("PoolTask ID " + id + " not found");
            }
            XmlWorkflowServiceFactory factory = XmlWorkflowServiceFactory.getInstance();
            Workflow workflow = factory.getWorkflowFactory().getWorkflow(task.getWorkflowItem().getCollection());
            Step step = workflow.getStep(task.getStepID());
            WorkflowActionConfig currentActionConfig = step.getActionConfig(task.getActionID());
            this.workflowService.doState(context, context.getCurrentUser(), request, task.getWorkflowItem().getID().intValue(), workflow, currentActionConfig);
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (MessagingException | WorkflowException | WorkflowConfigurationException e) {
            throw new UnprocessableEntityException(e.getMessage(), e);
        }
        return null;
    }

    public Page<PoolTaskRest> findAll(Context context, Pageable pageable) {
        throw new RuntimeException("Method not allowed!");
    }
}

