/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.RelationshipConverter;
import org.dspace.app.rest.converter.RelationshipTypeConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.RelationshipResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="core.relationship")
public class RelationshipRestRepository
extends DSpaceRestRepository<RelationshipRest, Integer> {
    private static final Logger log = Logger.getLogger(RelationshipRestRepository.class);
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private RelationshipConverter relationshipConverter;
    @Autowired
    private RelationshipTypeConverter relationshipTypeConverter;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ItemService itemService;

    public RelationshipRest findOne(Context context, Integer integer) {
        try {
            return this.relationshipConverter.fromModel((Relationship)this.relationshipService.find(context, integer.intValue()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<RelationshipRest> findAll(Context context, Pageable pageable) {
        List relationships = null;
        try {
            relationships = this.relationshipService.findAll(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(relationships, pageable).map((Converter)this.relationshipConverter);
        return page;
    }

    public Class<RelationshipRest> getDomainClass() {
        return RelationshipRest.class;
    }

    public DSpaceResource<RelationshipRest> wrapResource(RelationshipRest model, String ... rels) {
        return new RelationshipResource(model, this.utils, rels);
    }

    protected RelationshipRest createAndReturn(Context context, List<String> stringList) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        List list = this.utils.constructDSpaceObjectList(context, stringList);
        if (list.size() == 2 && ((DSpaceObject)list.get(0)).getType() == 2 && ((DSpaceObject)list.get(1)).getType() == 2) {
            Item leftItem = (Item)list.get(0);
            Item rightItem = (Item)list.get(1);
            RelationshipType relationshipType = (RelationshipType)this.relationshipTypeService.find(context, Integer.parseInt(req.getParameter("relationshipType")));
            EPerson ePerson = context.getCurrentUser();
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)leftItem, 1) || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)rightItem, 1)) {
                Relationship relationship = this.relationshipService.create(context, leftItem, rightItem, relationshipType, 0, 0);
                context.turnOffAuthorisationSystem();
                this.relationshipService.updateItem(context, relationship.getLeftItem());
                this.relationshipService.updateItem(context, relationship.getRightItem());
                context.restoreAuthSystemState();
                return this.relationshipConverter.fromModel(relationship);
            }
            throw new AccessDeniedException("You do not have write rights on this relationship's items");
        }
        throw new UnprocessableEntityException("The given items in the request were not valid items");
    }

    private boolean isAllowedToModifyRelationship(Context context, Relationship relationship, Item leftItem, Item rightItem) throws SQLException {
        return !(!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)leftItem, 1) && !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)rightItem, 1) || !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)relationship.getLeftItem(), 1) && !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)relationship.getRightItem(), 1));
    }

    protected void delete(Context context, Integer id) throws AuthorizeException {
        block4: {
            Relationship relationship = null;
            try {
                relationship = (Relationship)this.relationshipService.find(context, id.intValue());
                if (relationship == null) break block4;
                try {
                    this.relationshipService.delete(context, (Object)relationship);
                }
                catch (AuthorizeException e) {
                    throw new AccessDeniedException("You do not have write rights on this relationship's items");
                }
            }
            catch (SQLException e) {
                log.error((Object)("Error deleting Relationship specified by ID:" + id), (Throwable)e);
            }
        }
    }
}

