/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.model.hateoas.SiteResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.site")
public class SiteRestRepository
extends DSpaceObjectRestRepository<Site, SiteRest> {
    private final SiteService sitesv;

    @Autowired
    public SiteRestRepository(SiteService dsoService, SiteConverter dsoConverter) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)new /* Unavailable Anonymous Inner Class!! */);
        this.sitesv = dsoService;
    }

    public SiteRest findOne(Context context, UUID id) {
        Site site = null;
        try {
            site = (Site)this.sitesv.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (site == null) {
            return null;
        }
        return (SiteRest)this.dsoConverter.fromModel((DSpaceObject)site);
    }

    public Page<SiteRest> findAll(Context context, Pageable pageable) {
        ArrayList<Site> sites = new ArrayList<Site>();
        int total = 1;
        try {
            sites.add(this.sitesv.findSite(context));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(sites, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<SiteRest> getDomainClass() {
        return SiteRest.class;
    }

    public SiteResource wrapResource(SiteRest site, String ... rels) {
        return new SiteResource(site, this.utils, rels);
    }
}

