/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.converter.SubmissionFormConverter;
import org.dspace.app.rest.model.SubmissionFormRest;
import org.dspace.app.rest.model.hateoas.SubmissionFormResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionform")
public class SubmissionFormRestRepository
extends DSpaceRestRepository<SubmissionFormRest, String>
implements LinkRestRepository<SubmissionFormRest> {
    private DCInputsReader inputReader = new DCInputsReader();
    @Autowired
    private SubmissionFormConverter converter;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionFormRest findOne(Context context, String submitName) {
        DCInputSet inputConfig;
        try {
            inputConfig = this.inputReader.getInputsByFormName(submitName);
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (inputConfig == null) {
            return null;
        }
        return (SubmissionFormRest)this.converter.convert((Object)inputConfig);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionFormRest> findAll(Context context, Pageable pageable) {
        List subConfs = new ArrayList();
        int total = this.inputReader.countInputs();
        try {
            subConfs = this.inputReader.getAllInputs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        Page page = new PageImpl(subConfs, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    public Class<SubmissionFormRest> getDomainClass() {
        return SubmissionFormRest.class;
    }

    public SubmissionFormResource wrapResource(SubmissionFormRest sd, String ... rels) {
        return new SubmissionFormResource(sd, this.utils, rels);
    }
}

