/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.WorkflowItemConverter;
import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.WorkflowItemRest;
import org.dspace.app.rest.model.hateoas.WorkflowItemResource;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="workflow.workflowitem")
public class WorkflowItemRestRepository
extends DSpaceRestRepository<WorkflowItemRest, Integer> {
    public static final String OPERATION_PATH_SECTIONS = "sections";
    private static final Logger log = Logger.getLogger(WorkflowItemRestRepository.class);
    @Autowired
    XmlWorkflowItemService wis;
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    WorkflowItemConverter converter;
    @Autowired
    SubmissionService submissionService;
    @Autowired
    EPersonServiceImpl epersonService;
    @Autowired
    WorkflowService<XmlWorkflowItem> wfs;
    private SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();

    @PreAuthorize(value="hasPermission(#id, 'WORKFLOWITEM', 'READ')")
    public WorkflowItemRest findOne(Context context, Integer id) {
        XmlWorkflowItem witem = null;
        try {
            witem = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (witem == null) {
            return null;
        }
        return this.converter.fromModel(witem);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkflowItemRest> findAll(Context context, Pageable pageable) {
        List witems = null;
        int total = 0;
        try {
            total = this.wis.countAll(context);
            witems = this.wis.findAll(context, Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(witems, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    @SearchRestMethod(name="findBySubmitter")
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkflowItemRest> findBySubmitter(@Parameter(value="uuid") UUID submitterID, Pageable pageable) {
        List witems = null;
        int total = 0;
        try {
            Context context = this.obtainContext();
            EPerson ep = this.epersonService.find(context, submitterID);
            witems = this.wis.findBySubmitter(context, ep, Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
            total = this.wis.countBySubmitter(context, ep);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(witems, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    protected WorkflowItemRest createAndReturn(Context context, List<String> stringList) {
        XmlWorkflowItem source;
        if (stringList == null || stringList.isEmpty() || stringList.size() > 1) {
            throw new UnprocessableEntityException("The given URI list could not be properly parsed to one result");
        }
        try {
            source = this.submissionService.createWorkflowItem(context, stringList.get(0));
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (WorkflowException e) {
            throw new UnprocessableEntityException("Invalid workflow action: " + e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (source.getItem().isArchived()) {
            return null;
        }
        return (WorkflowItemRest)this.converter.convert((Object)source);
    }

    public Class<WorkflowItemRest> getDomainClass() {
        return WorkflowItemRest.class;
    }

    public WorkflowItemResource wrapResource(WorkflowItemRest witem, String ... rels) {
        return new WorkflowItemResource(witem, this.utils, rels);
    }

    public WorkflowItemRest upload(HttpServletRequest request, String apiCategory, String model, Integer id, MultipartFile file) throws Exception {
        Context context = this.obtainContext();
        WorkflowItemRest wsi = (WorkflowItemRest)this.findOne((Serializable)id);
        XmlWorkflowItem source = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
        SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByName(wsi.getSubmissionDefinition().getName());
        for (int i = 0; i < submissionConfig.getNumberOfSteps(); ++i) {
            SubmissionStepConfig stepConfig = submissionConfig.getStep(i);
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                Object stepInstance = stepClass.newInstance();
                if (!UploadableStep.class.isAssignableFrom(stepClass)) continue;
                UploadableStep uploadableStep = (UploadableStep)stepInstance;
                uploadableStep.doPreProcessing(context, (InProgressSubmission)source);
                ErrorRest err = uploadableStep.upload(context, this.submissionService, stepConfig, (InProgressSubmission)source, file);
                uploadableStep.doPostProcessing(context, (InProgressSubmission)source);
                if (err == null) continue;
                errors.add(err);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        wsi = (WorkflowItemRest)this.converter.convert((Object)source);
        if (!errors.isEmpty()) {
            wsi.getErrors().addAll(errors);
        }
        context.commit();
        return wsi;
    }

    public void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws SQLException, AuthorizeException {
        List operations = patch.getOperations();
        WorkflowItemRest wsi = (WorkflowItemRest)this.findOne((Serializable)id);
        XmlWorkflowItem source = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        for (Operation op : operations) {
            String[] path = op.getPath().substring(1).split("/", 3);
            if (OPERATION_PATH_SECTIONS.equals(path[0])) {
                String section = path[1];
                this.evaluatePatch(context, request, source, wsi, section, op);
                continue;
            }
            throw new PatchBadRequestException("Patch path operation need to starts with 'sections'");
        }
        this.wis.update(context, (InProgressSubmission)source);
    }

    private void evaluatePatch(Context context, HttpServletRequest request, XmlWorkflowItem source, WorkflowItemRest wsi, String section, Operation op) {
        SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByName(wsi.getSubmissionDefinition().getName());
        for (int stepNum = 0; stepNum < submissionConfig.getNumberOfSteps(); ++stepNum) {
            SubmissionStepConfig stepConfig = submissionConfig.getStep(stepNum);
            if (!section.equals(stepConfig.getId())) continue;
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                Object stepInstance = stepClass.newInstance();
                if (!(stepInstance instanceof AbstractRestProcessingStep)) {
                    throw new PatchBadRequestException("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not extend the class org.dspace.submit.AbstractProcessingStep! Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
                }
                AbstractRestProcessingStep stepProcessing = (AbstractRestProcessingStep)stepClass.newInstance();
                stepProcessing.doPreProcessing(context, (InProgressSubmission)source);
                stepProcessing.doPatchProcessing(context, this.getRequestService().getCurrentRequest(), (InProgressSubmission)source, op);
                stepProcessing.doPostProcessing(context, (InProgressSubmission)source);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void delete(Context context, Integer id) {
        XmlWorkflowItem witem = null;
        try {
            witem = (XmlWorkflowItem)this.wis.find(context, id.intValue());
            if (witem == null) {
                throw new ResourceNotFoundException("WorkflowItem ID " + id + " not found");
            }
            this.wfs.abort(context, (WorkflowItem)witem, context.getCurrentUser());
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

