/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch;

import java.util.List;
import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.patch.Operation;

public abstract class AbstractResourcePatch<R extends RestModel> {
    public R patch(R restModel, List<Operation> operations) {
        block14: for (Operation op : operations) {
            switch (op.getOp()) {
                case "add": {
                    restModel = this.add(restModel, op);
                    continue block14;
                }
                case "replace": {
                    restModel = this.replace(restModel, op);
                    continue block14;
                }
                case "remove": {
                    restModel = this.remove(restModel, op);
                    continue block14;
                }
                case "copy": {
                    restModel = this.copy(restModel, op);
                    continue block14;
                }
                case "move": {
                    restModel = this.move(restModel, op);
                    continue block14;
                }
            }
            throw new PatchBadRequestException("Missing or illegal patch operation: " + op.getOp());
        }
        return restModel;
    }

    protected R add(R restModel, Operation operation) throws UnprocessableEntityException, PatchBadRequestException {
        throw new UnprocessableEntityException("The add operation is not supported.");
    }

    protected R replace(R restModel, Operation operation) throws UnprocessableEntityException, PatchBadRequestException {
        throw new UnprocessableEntityException("The replace operation is not supported.");
    }

    protected R remove(R restModel, Operation operation) throws UnprocessableEntityException, PatchBadRequestException {
        throw new UnprocessableEntityException("The remove operation is not supported.");
    }

    protected R copy(R restModel, Operation operation) throws UnprocessableEntityException, PatchBadRequestException {
        throw new UnprocessableEntityException("The copy operation is not supported.");
    }

    protected R move(R restModel, Operation operation) throws UnprocessableEntityException, PatchBadRequestException {
        throw new UnprocessableEntityException("The move operation is not supported.");
    }
}

