/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.JsonPatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.converter.JsonPatchConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.patch.AbstractResourcePatch;

public abstract class DSpaceObjectPatch<R extends DSpaceObjectRest>
extends AbstractResourcePatch<R> {
    private static final String METADATA_PATH = "/metadata";
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonPatchConverter jsonPatchConverter = new JsonPatchConverter(this.objectMapper);

    public R patch(R dsoRest, List<Operation> operations) {
        ArrayList<Operation> metadataOperations = new ArrayList<Operation>();
        ArrayList<Operation> otherOperations = new ArrayList<Operation>();
        for (Operation operation : operations) {
            String path = operation.getPath();
            if (path.equals(METADATA_PATH) || path.startsWith("/metadata/")) {
                metadataOperations.add(operation);
                continue;
            }
            otherOperations.add(operation);
        }
        if (!metadataOperations.isEmpty()) {
            dsoRest.setMetadata(this.applyMetadataPatch(this.jsonPatchConverter.convert(new Patch(metadataOperations)), dsoRest.getMetadata()));
        }
        return (R)((DSpaceObjectRest)super.patch(dsoRest, otherOperations));
    }

    private MetadataRest applyMetadataPatch(JsonNode patch, MetadataRest metadataRest) {
        try {
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            JsonNode metadataNode = this.objectMapper.valueToTree((Object)metadataRest);
            objectNode.replace("metadata", metadataNode);
            JsonPatch.applyInPlace((JsonNode)patch, (JsonNode)objectNode);
            return (MetadataRest)this.objectMapper.treeToValue((TreeNode)objectNode.get("metadata"), MetadataRest.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

