/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.factories;

import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.repository.patch.factories.impl.ItemDiscoverableReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.ItemWithdrawReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.ResourcePatchOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItemOperationFactory {
    @Autowired
    ItemDiscoverableReplaceOperation itemDiscoverableReplaceOperation;
    @Autowired
    ItemWithdrawReplaceOperation itemWithdrawReplaceOperation;
    private static final String OPERATION_PATH_WITHDRAW = "/withdrawn";
    private static final String OPERATION_PATH_DISCOVERABLE = "/discoverable";

    public ResourcePatchOperation<ItemRest> getReplaceOperationForPath(String path) {
        switch (path) {
            case "/discoverable": {
                return this.itemDiscoverableReplaceOperation;
            }
            case "/withdrawn": {
                return this.itemWithdrawReplaceOperation;
            }
        }
        throw new PatchBadRequestException("Missing patch operation for: " + path);
    }
}

