/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.factories.impl;

import org.apache.log4j.Logger;
import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.factories.impl.ReplacePatchOperation;
import org.springframework.stereotype.Component;

@Component
public class ItemDiscoverableReplaceOperation
extends ReplacePatchOperation<ItemRest, Boolean> {
    private static final Logger log = Logger.getLogger(ItemDiscoverableReplaceOperation.class);

    public ItemRest replace(ItemRest item, Operation operation) {
        Boolean discoverable = this.getBooleanOperationValue(operation.getValue());
        item.setDiscoverable(discoverable.booleanValue());
        return item;
    }

    void checkModelForExistingValue(ItemRest resource, Operation operation) {
        if (Boolean.valueOf(resource.getDiscoverable()) == null) {
            throw new PatchBadRequestException("Attempting to replace a non-existent value.");
        }
    }

    protected Class<Boolean[]> getArrayClassForEvaluation() {
        return Boolean[].class;
    }

    protected Class<Boolean> getClassForEvaluation() {
        return Boolean.class;
    }
}

