/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.factories.impl;

import org.apache.log4j.Logger;
import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.factories.impl.ReplacePatchOperation;
import org.springframework.stereotype.Component;

@Component
public class ItemWithdrawReplaceOperation
extends ReplacePatchOperation<ItemRest, Boolean> {
    private static final Logger log = Logger.getLogger(ItemWithdrawReplaceOperation.class);

    public ItemRest replace(ItemRest item, Operation operation) {
        Boolean withdraw = this.getBooleanOperationValue(operation.getValue());
        if (withdraw.booleanValue()) {
            if (!item.getWithdrawn() && !item.getInArchive()) {
                throw new UnprocessableEntityException("Cannot withdraw item when it is not in archive.");
            }
            if (item.getWithdrawn()) {
                return item;
            }
            item.setWithdrawn(true);
            return item;
        }
        if (!item.getWithdrawn()) {
            return item;
        }
        item.setWithdrawn(false);
        return item;
    }

    void checkModelForExistingValue(ItemRest resource, Operation operation) {
        if (Boolean.valueOf(resource.getWithdrawn()) == null) {
            throw new PatchBadRequestException("Attempting to replace a non-existent value.");
        }
    }

    protected Class<Boolean[]> getArrayClassForEvaluation() {
        return Boolean[].class;
    }

    protected Class<Boolean> getClassForEvaluation() {
        return Boolean.class;
    }
}

