/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.File;
import javax.naming.InitialContext;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class DSpaceKernelInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(DSpaceKernelInitializer.class);
    private transient DSpaceKernel dspaceKernel;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        String dspaceHome = applicationContext.getEnvironment().getProperty("dspace.dir");
        this.dspaceKernel = DSpaceKernelManager.getDefaultKernel();
        if (this.dspaceKernel == null) {
            DSpaceKernelImpl kernelImpl = null;
            try {
                kernelImpl = DSpaceKernelInit.getKernel(null);
                if (!kernelImpl.isRunning()) {
                    kernelImpl.start(this.getProvidedHome(dspaceHome));
                }
                this.dspaceKernel = kernelImpl;
            }
            catch (Exception e) {
                try {
                    if (kernelImpl != null) {
                        kernelImpl.destroy();
                    }
                    this.dspaceKernel = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String message = "Failure during ServletContext initialisation: " + e.getMessage();
                log.error(message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        if (applicationContext.getParent() == null) {
            applicationContext.setParent((ApplicationContext)this.dspaceKernel.getServiceManager().getApplicationContext());
            applicationContext.addApplicationListener((ApplicationListener)new DSpaceKernelDestroyer(this, this.dspaceKernel));
        }
    }

    private String getProvidedHome(String dspaceHome) {
        File test;
        String providedHome = null;
        try {
            InitialContext ctx = new InitialContext();
            providedHome = (String)ctx.lookup("java:/comp/env/dspace.dir");
        }
        catch (Exception ctx) {
            // empty catch block
        }
        if (providedHome == null && dspaceHome != null && !dspaceHome.equals("") && !dspaceHome.equals("${dspace.dir}") && (test = new File(dspaceHome)).exists() && new File(test, DSpaceConfigurationService.DSPACE_CONFIG_PATH).exists()) {
            providedHome = dspaceHome;
        }
        return providedHome;
    }
}

