/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.utils.MultipartFileSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultipartFileSender {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String METHOD_HEAD = "HEAD";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String CONTENT_TYPE_MULTITYPE_WITH_BOUNDARY = "multipart/byteranges; boundary=MULTIPART_BYTERANGES";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String ETAG = "ETag";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String RANGE = "Range";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String IF_RANGE = "If-Range";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String BYTES = "bytes";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String EXPIRES = "Expires";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String IMAGE = "image";
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String BYTES_RANGE_FORMAT = "bytes %d-%d/%d";
    private static final String CONTENT_DISPOSITION_FORMAT = "%s;filename=\"%s\"";
    private static final String BYTES_DINVALID_BYTE_RANGE_FORMAT = "bytes */%d";
    private static final String CACHE_CONTROL = "Cache-Control";
    private int bufferSize = 1000000;
    private static final long DEFAULT_EXPIRE_TIME = 3600000L;
    private static final String CACHE_CONTROL_SETTING = "private,no-cache";
    private BufferedInputStream inputStream;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String contentType;
    private String disposition;
    private long lastModified;
    private long length;
    private String fileName;
    private String checksum;

    public MultipartFileSender(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public static MultipartFileSender fromInputStream(InputStream inputStream) {
        return new MultipartFileSender(inputStream);
    }

    public MultipartFileSender with(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        return this;
    }

    public MultipartFileSender with(HttpServletResponse httpResponse) {
        this.response = httpResponse;
        return this;
    }

    public MultipartFileSender withLength(long length) {
        this.length = length;
        return this;
    }

    public MultipartFileSender withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public MultipartFileSender withChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    public MultipartFileSender withMimetype(String mimetype) {
        this.contentType = mimetype;
        return this;
    }

    public MultipartFileSender withLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public MultipartFileSender withBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        return this;
    }

    public MultipartFileSender withDisposition(String contentDisposition) {
        this.disposition = contentDisposition;
        return this;
    }

    public void serveResource() throws IOException {
        Range full = this.getFullRange();
        List ranges = this.getRanges(full);
        if (ranges == null) {
            return;
        }
        this.log.debug("Content-Type : {}", (Object)this.contentType);
        this.response.reset();
        this.response.setBufferSize(this.bufferSize);
        this.response.setHeader("Content-Type", this.contentType);
        this.response.setHeader("Accept-Ranges", "bytes");
        this.response.setHeader("ETag", this.checksum);
        this.response.setDateHeader("Last-Modified", this.lastModified);
        this.response.setDateHeader("Expires", System.currentTimeMillis() + 3600000L);
        this.response.setHeader("Cache-Control", "private,no-cache");
        if (MultipartFileSender.isNullOrEmpty((String)this.disposition)) {
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            } else if (!this.contentType.startsWith("image")) {
                String accept = this.request.getHeader("Accept");
                this.disposition = accept != null && MultipartFileSender.accepts((String)accept, (String)this.contentType) ? "inline" : "attachment";
            }
        }
        this.response.setHeader("Content-Disposition", String.format("%s;filename=\"%s\"", this.disposition, this.fileName));
        this.log.debug("Content-Disposition : {}", (Object)this.disposition);
        if ("HEAD".equals(this.request.getMethod())) {
            this.log.debug("HEAD request - skipping content");
            return;
        }
        try (ServletOutputStream output = this.response.getOutputStream();){
            if (this.hasNoRanges(full, ranges)) {
                this.log.debug("Return full file");
                this.response.setContentType(this.contentType);
                this.response.setHeader("Content-Length", String.valueOf(this.length));
                Range.access$000((InputStream)this.inputStream, (OutputStream)output, (long)this.length, (long)0L, (long)this.length, (int)this.bufferSize);
            } else if (ranges.size() == 1) {
                Range r = (Range)ranges.get(0);
                this.log.debug("Return 1 part of file : from ({}) to ({})", (Object)r.start, (Object)r.end);
                this.response.setContentType(this.contentType);
                this.response.setHeader("Content-Range", String.format("bytes %d-%d/%d", r.start, r.end, r.total));
                this.response.setHeader("Content-Length", String.valueOf(r.length));
                this.response.setStatus(206);
                Range.access$000((InputStream)this.inputStream, (OutputStream)output, (long)this.length, (long)r.start, (long)r.length, (int)this.bufferSize);
            } else {
                this.response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                this.response.setStatus(206);
                ServletOutputStream sos = output;
                for (Range r : ranges) {
                    this.log.debug("Return multi part of file : from ({}) to ({})", (Object)r.start, (Object)r.end);
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + this.contentType);
                    sos.println("Content-Range: " + String.format("bytes %d-%d/%d", r.start, r.end, r.total));
                    this.inputStream.mark(0);
                    Range.access$000((InputStream)this.inputStream, (OutputStream)output, (long)this.length, (long)r.start, (long)r.length, (int)this.bufferSize);
                    this.inputStream.reset();
                    sos.println();
                }
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
    }

    public boolean isValid() throws IOException {
        if (this.response == null || this.request == null) {
            return false;
        }
        if (this.inputStream == null) {
            this.log.error("Input stream has no content");
            this.response.sendError(404);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.fileName)) {
            this.response.sendError(500);
            return false;
        }
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        if (Objects.nonNull(ifNoneMatch) && MultipartFileSender.matches((String)ifNoneMatch, (String)this.checksum)) {
            this.log.debug("If-None-Match header should contain \"*\" or ETag. If so, then return 304.");
            this.response.setHeader("ETag", this.checksum);
            this.response.sendError(304);
            return false;
        }
        long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
        if (Objects.isNull(ifNoneMatch) && ifModifiedSince != -1L && ifModifiedSince + 1000L > this.lastModified) {
            this.log.debug("If-Modified-Since header should be greater than LastModified. If so, then return 304.");
            this.response.setHeader("ETag", this.checksum);
            this.response.sendError(304);
            return false;
        }
        String ifMatch = this.request.getHeader("If-Match");
        if (Objects.nonNull(ifMatch) && !MultipartFileSender.matches((String)ifMatch, (String)this.checksum)) {
            this.log.error("If-Match header should contain \"*\" or ETag. If not, then return 412.");
            this.response.sendError(416);
            return false;
        }
        long ifUnmodifiedSince = this.request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= this.lastModified) {
            this.log.error("If-Unmodified-Since header should be greater than LastModified. If not, then return 412.");
            this.response.sendError(412);
            return false;
        }
        return true;
    }

    public boolean isNoRangeRequest() throws IOException {
        List ranges;
        Range full = this.getFullRange();
        return this.hasNoRanges(full, ranges = this.getRanges(full));
    }

    private boolean hasNoRanges(Range full, List<Range> ranges) {
        return ranges != null && (ranges.isEmpty() || ranges.get(0) == full);
    }

    private Range getFullRange() {
        return new Range(0L, this.length - 1L, this.length);
    }

    private List<Range> getRanges(Range fullRange) throws IOException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = this.request.getHeader("Range");
        if (Objects.nonNull(range)) {
            block12: {
                if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                    this.log.error("Range header should match format \"bytes=n-n,n-n,n-n...\". If not, then return 416.");
                    this.response.setHeader("Content-Range", String.format("bytes */%d", this.length));
                    this.response.sendError(416);
                    return null;
                }
                String ifRange = this.request.getHeader("If-Range");
                if (Objects.nonNull(ifRange) && !ifRange.equals(this.fileName)) {
                    try {
                        long ifRangeTime = this.request.getDateHeader("If-Range");
                        if (ifRangeTime == -1L || ifRangeTime + 1000L <= this.lastModified) {
                            ranges.add(fullRange);
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        if (MultipartFileSender.matches((String)ifRange, (String)this.checksum)) break block12;
                        ranges.add(fullRange);
                    }
                }
            }
            if (ranges.isEmpty()) {
                this.log.debug("If any valid If-Range header, then process each part of byte range.");
                for (String part : range.substring(6).split(",")) {
                    long start = Range.sublong((String)part, (int)0, (int)part.indexOf("-"));
                    long end = Range.sublong((String)part, (int)(part.indexOf("-") + 1), (int)part.length());
                    if (start == -1L) {
                        start = this.length - end;
                        end = this.length - 1L;
                    } else if (end == -1L || end > this.length - 1L) {
                        end = this.length - 1L;
                    }
                    if (start > end) {
                        this.log.warn("Check if Range is syntactically valid. If not, then return 416.");
                        this.response.setHeader("Content-Range", String.format("bytes */%d", this.length));
                        this.response.sendError(416);
                        return null;
                    }
                    ranges.add(new Range(start, end, this.length));
                }
            }
        }
        return ranges;
    }

    private static boolean isNullOrEmpty(String disposition) {
        return StringUtils.isBlank((CharSequence)disposition);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }
}

