/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.Ostermiller.util.ExcelCSVPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset {
    private int nbRows;
    private int nbCols;
    private List<String> colLabels;
    private List<String> rowLabels;
    private String colTitle;
    private String rowTitle;
    private List<Map<String, String>> colLabelsAttrs;
    private List<Map<String, String>> rowLabelsAttrs;
    private float[][] matrix;
    private String format = "0";

    public Dataset(int rows, int cols) {
        this.matrix = new float[rows][cols];
        this.nbRows = rows;
        this.nbCols = cols;
        this.initColumnLabels(cols);
        this.initRowLabels(rows);
    }

    public Dataset(float[][] matrix) {
        this.matrix = matrix;
        this.nbRows = matrix.length;
        if (0 < matrix.length && 0 < matrix[0].length) {
            this.nbCols = matrix[0].length;
        }
        this.initColumnLabels(this.nbCols);
        this.initRowLabels(this.nbRows);
    }

    private void initRowLabels(int rows) {
        this.rowLabels = new ArrayList<String>(rows);
        this.rowLabelsAttrs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < rows; ++i) {
            this.rowLabels.add("Row " + (i + 1));
            this.rowLabelsAttrs.add(new HashMap());
        }
    }

    private void initColumnLabels(int nbCols) {
        this.colLabels = new ArrayList<String>(nbCols);
        this.colLabelsAttrs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < nbCols; ++i) {
            this.colLabels.add("Column " + (i + 1));
            this.colLabelsAttrs.add(new HashMap());
        }
    }

    public void setColLabel(int n, String label) {
        this.colLabels.set(n, label);
    }

    public void setRowLabel(int n, String label) {
        this.rowLabels.set(n, label);
    }

    public String getRowTitle() {
        return this.rowTitle;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(String colTitle) {
        this.colTitle = colTitle;
    }

    public void setRowTitle(String rowTitle) {
        this.rowTitle = rowTitle;
    }

    public void setRowLabelAttr(int pos, String attrName, String attr) {
        Map<String, String> attrs = this.rowLabelsAttrs.get(pos);
        attrs.put(attrName, attr);
        this.rowLabelsAttrs.set(pos, attrs);
    }

    public void setRowLabelAttr(int pos, Map<String, String> attrMap) {
        this.rowLabelsAttrs.set(pos, attrMap);
    }

    public void setColLabelAttr(int pos, String attrName, String attr) {
        Map<String, String> attrs = this.colLabelsAttrs.get(pos);
        attrs.put(attrName, attr);
        this.colLabelsAttrs.set(pos, attrs);
    }

    public void setColLabelAttr(int pos, Map<String, String> attrMap) {
        this.colLabelsAttrs.set(pos, attrMap);
    }

    public List<Map<String, String>> getColLabelsAttrs() {
        return this.colLabelsAttrs;
    }

    public List<Map<String, String>> getRowLabelsAttrs() {
        return this.rowLabelsAttrs;
    }

    public List<String> getColLabels() {
        return this.colLabels;
    }

    public List<String> getRowLabels() {
        return this.rowLabels;
    }

    public float[][] getMatrix() {
        return this.matrix;
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public int getNbCols() {
        return this.nbCols;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String[][] getMatrixFormatted() {
        DecimalFormat decimalFormat = new DecimalFormat(this.format);
        String[][] strMatrix = new String[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[i].length; ++j) {
                strMatrix[i][j] = decimalFormat.format(this.matrix[i][j]);
            }
        }
        return strMatrix;
    }

    public void addValueToMatrix(int row, int coll, float value) {
        this.matrix[row][coll] = value;
    }

    public void addValueToMatrix(int row, int coll, String value) throws ParseException {
        DecimalFormat decimalFormat = new DecimalFormat(this.format);
        Number number = decimalFormat.parse(value);
        this.matrix[row][coll] = number.floatValue();
    }

    public boolean containsNonZeroValues() {
        if (this.matrix != null) {
            float[][] arr$ = this.matrix;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float[] vector;
                for (float v : vector = arr$[i$]) {
                    if (v == 0.0f) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void flipRowCols() {
        Object backup;
        if (0 < this.matrix.length && 0 < this.matrix[0].length) {
            float[][] newMatrix = new float[this.matrix[0].length][this.matrix.length];
            for (int i = 0; i < this.matrix.length; ++i) {
                for (int j = 0; j < this.matrix[i].length; ++j) {
                    newMatrix[j][i] = this.matrix[i][j];
                }
            }
            backup = this.colLabels;
            this.colLabels = this.rowLabels;
            this.rowLabels = backup;
            List<Map<String, String>> backList = this.colLabelsAttrs;
            this.colLabelsAttrs = this.rowLabelsAttrs;
            this.rowLabelsAttrs = backList;
            this.matrix = newMatrix;
        }
        int backUp = this.nbRows;
        this.nbRows = this.nbCols;
        this.nbCols = backUp;
        backup = this.rowTitle;
        this.rowTitle = this.colTitle;
        this.colTitle = backup;
    }

    public ByteArrayOutputStream exportAsCSV() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExcelCSVPrinter ecsvp = new ExcelCSVPrinter((OutputStream)baos);
        ecsvp.changeDelimiter(';');
        ecsvp.setAlwaysQuote(true);
        List<String> colLabels = this.getColLabels();
        ecsvp.write("");
        for (String colLabel : colLabels) {
            ecsvp.write(colLabel);
        }
        ecsvp.writeln();
        List<String> rowLabels = this.getRowLabels();
        String[][] matrix = this.getMatrixFormatted();
        for (int i = 0; i < rowLabels.size(); ++i) {
            String rowLabel = rowLabels.get(i);
            ecsvp.write(rowLabel);
            for (int j = 0; j < matrix[i].length; ++j) {
                ecsvp.write(matrix[i][j]);
            }
            ecsvp.writeln();
        }
        ecsvp.flush();
        ecsvp.close();
        return baos;
    }
}

