/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiderDetector {
    public static void main(String[] args) throws Exception {
        String ip;
        int i;
        String logLine;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("l", "logfile", true, "type: Input log file");
        options.addOption("s", "spiderfile", true, "type: Spider ip file");
        CommandLine line = parser.parse(options, args);
        if (!line.hasOption("l")) {
            System.out.println("We need our log file");
            return;
        }
        String logFileLoc = line.getOptionValue("l");
        if (!line.hasOption("s")) {
            System.out.println("We need a spider ip output file");
            return;
        }
        String spiderIpPath = line.getOptionValue("s");
        BufferedReader in = new BufferedReader(new FileReader(logFileLoc));
        Vector<String> spiders = new Vector<String>();
        while ((logLine = in.readLine()) != null) {
            String ip2;
            if (!logLine.contains("robots.txt") || spiders.contains(ip2 = logLine.substring(0, logLine.indexOf("-")).trim())) continue;
            spiders.add(ip2);
        }
        in.close();
        File spiderIpFile = new File(spiderIpPath);
        Vector<Object> oldSpiderIds = new Vector();
        if (spiderIpFile.exists()) {
            oldSpiderIds = SpiderDetector.readIpAddresses(spiderIpFile);
        }
        Vector<String> newSpiderIds = new Vector<String>();
        for (int i2 = 0; i2 < spiders.size(); ++i2) {
            String spiderIp = (String)spiders.elementAt(i2);
            if (oldSpiderIds.contains(spiderIp)) continue;
            newSpiderIds.add(spiderIp);
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(spiderIpFile));
        for (i = 0; i < oldSpiderIds.size(); ++i) {
            ip = (String)oldSpiderIds.elementAt(i);
            output.write(ip + "\n");
        }
        for (i = 0; i < newSpiderIds.size(); ++i) {
            ip = (String)newSpiderIds.elementAt(i);
            System.out.println("Adding new ip: " + ip);
            output.write(ip + "\n");
        }
        output.flush();
        output.close();
    }

    public static Vector<String> readIpAddresses(File spiderIpFile) throws IOException {
        String ip;
        Vector<String> ips = new Vector<String>();
        if (!spiderIpFile.exists()) {
            return ips;
        }
        BufferedReader in = new BufferedReader(new FileReader(spiderIpFile));
        while ((ip = in.readLine()) != null) {
            ips.add(ip);
        }
        in.close();
        return ips;
    }
}

