/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPTable {
    private HashMap<String, HashMap<String, HashMap<String, HashSet<String>>>> map = new HashMap();

    public void add(String ip) throws IPFormatException {
        String[] end;
        String[] start;
        String[] range = ip.split("-");
        if (range.length >= 2) {
            start = range[0].trim().split("/")[0].split("\\.");
            end = range[1].trim().split("/")[0].split("\\.");
            if (start.length != 4 || end.length != 4) {
                throw new IPFormatException(ip + " - Ranges need to be full IPv4 Addresses");
            }
            if (!(start[0].equals(end[0]) && start[1].equals(end[1]) && start[2].equals(end[2]))) {
                throw new IPFormatException(ip + " - Ranges can only be across the last subnet x.y.z.0 - x.y.z.254");
            }
        } else {
            String[] subnets = ip.split("\\.");
            if (subnets.length < 3) {
                throw new IPFormatException(ip + " - require at least three subnet places (255.255.255.0");
            }
            start = subnets;
            end = subnets;
        }
        if (start.length >= 3) {
            HashSet<String> third;
            HashMap<String, HashSet<String>> second;
            HashMap<String, HashMap<String, HashSet<String>>> first = this.map.get(start[0]);
            if (first == null) {
                first = new HashMap();
                this.map.put(start[0], first);
            }
            if ((second = first.get(start[1])) == null) {
                second = new HashMap();
                first.put(start[1], second);
            }
            if ((third = second.get(start[2])) == null) {
                third = new HashSet();
                second.put(start[2], third);
            }
            if (start.length == 3) {
                third.add("*");
            }
            if (third.contains("*")) {
                return;
            }
            if (start.length >= 4) {
                int s = Integer.valueOf(start[3]);
                int e = Integer.valueOf(end[3]);
                for (int i = s; i <= e; ++i) {
                    third.add(String.valueOf(i));
                }
            }
        }
    }

    public boolean contains(String ip) throws IPFormatException {
        String[] subnets = ip.split("\\.");
        if (subnets.length != 4) {
            throw new IPFormatException("needs to be single IP Address");
        }
        HashMap<String, HashMap<String, HashSet<String>>> first = this.map.get(subnets[0]);
        if (first == null) {
            return false;
        }
        HashMap<String, HashSet<String>> second = first.get(subnets[1]);
        if (second == null) {
            return false;
        }
        HashSet<String> third = second.get(subnets[2]);
        if (third == null) {
            return false;
        }
        return third.contains(subnets[3]) || third.contains("*");
    }

    public Set<String> toSet() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, HashMap<String, HashMap<String, HashSet<String>>>> first : this.map.entrySet()) {
            String firstString = first.getKey();
            HashMap<String, HashMap<String, HashSet<String>>> secondMap = first.getValue();
            for (Map.Entry<String, HashMap<String, HashSet<String>>> second : secondMap.entrySet()) {
                String secondString = second.getKey();
                HashMap<String, HashSet<String>> thirdMap = second.getValue();
                for (Map.Entry<String, HashSet<String>> third : thirdMap.entrySet()) {
                    String thirdString = third.getKey();
                    HashSet<String> fourthSet = third.getValue();
                    if (fourthSet.contains("*")) {
                        set.add(firstString + "." + secondString + "." + thirdString);
                        continue;
                    }
                    for (String fourth : fourthSet) {
                        set.add(firstString + "." + secondString + "." + thirdString + "." + fourth);
                    }
                }
            }
        }
        return set;
    }

    public class IPFormatException
    extends Exception {
        public IPFormatException(String s) {
            super(s);
        }
    }
}

