/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.eperson.EPerson;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;

public class SolrLogger {
    private static Logger log;
    private static final CommonsHttpSolrServer solr;
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final LookupService locationService;
    private static final boolean useProxies;
    private static Map<String, String> metadataStorageInfo;
    private static String filterQuery;

    public static void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        if (solr == null || locationService == null) {
            return;
        }
        boolean isSpiderBot = SpiderDetector.isSpider(request);
        try {
            if (isSpiderBot && !ConfigurationManager.getBooleanProperty((String)"solr.statistics.logBots", (boolean)true)) {
                return;
            }
            SolrInputDocument doc1 = new SolrInputDocument();
            String ip = request.getRemoteAddr();
            if (SolrLogger.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            doc1.addField("ip", (Object)ip);
            doc1.addField("id", (Object)dspaceObject.getID());
            doc1.addField("type", (Object)dspaceObject.getType());
            doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
            if (currentUser != null) {
                doc1.addField("epersonid", (Object)currentUser.getID());
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                doc1.addField("dns", (Object)dns.toLowerCase());
            }
            catch (Exception e) {
                log.error((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            Location location = locationService.getLocation(ip);
            if (!(location == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    doc1.addField("continent", (Object)LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                doc1.addField("countryCode", (Object)location.countryCode);
                doc1.addField("city", (Object)location.city);
                doc1.addField("latitude", (Object)Float.valueOf(location.latitude));
                doc1.addField("longitude", (Object)Float.valueOf(location.longitude));
                doc1.addField("isBot", (Object)isSpiderBot);
                if (request.getHeader("User-Agent") != null) {
                    doc1.addField("userAgent", (Object)request.getHeader("User-Agent"));
                }
            }
            if (dspaceObject instanceof Item) {
                Item item = (Item)dspaceObject;
                for (String storedField : metadataStorageInfo.keySet()) {
                    DCValue[] vals;
                    String dcField = metadataStorageInfo.get(storedField);
                    for (DCValue val1 : vals = item.getMetadata(dcField.split("\\.")[0], dcField.split("\\.")[1], dcField.split("\\.")[2], "*")) {
                        String val = val1.value;
                        doc1.addField(String.valueOf(storedField), (Object)val);
                        doc1.addField(storedField + "_search", (Object)val.toLowerCase());
                    }
                }
            }
            SolrLogger.storeParents(doc1, dspaceObject);
            solr.add(doc1);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getMetadataStorageInfo() {
        return metadataStorageInfo;
    }

    public static void storeParents(SolrInputDocument doc1, DSpaceObject dso) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        for (Community comm = (Community)dso; comm != null && comm.getParentCommunity() != null; comm = comm.getParentCommunity()) {
                            doc1.addField("owningComm", (Object)comm.getID());
                        }
                        break block6;
                    }
                    if (!(dso instanceof org.dspace.content.Collection)) break block7;
                    org.dspace.content.Collection coll = (org.dspace.content.Collection)dso;
                    for (int i = 0; i < coll.getCommunities().length; ++i) {
                        Community community = coll.getCommunities()[i];
                        doc1.addField("owningComm", (Object)community.getID());
                        SolrLogger.storeParents(doc1, (DSpaceObject)community);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                for (int i = 0; i < item.getCollections().length; ++i) {
                    org.dspace.content.Collection collection = item.getCollections()[i];
                    doc1.addField("owningColl", (Object)collection.getID());
                    SolrLogger.storeParents(doc1, (DSpaceObject)collection);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            for (int i = 0; i < bitstream.getBundles().length; ++i) {
                Bundle bundle = bitstream.getBundles()[i];
                for (int j = 0; j < bundle.getItems().length; ++j) {
                    Item item = bundle.getItems()[j];
                    doc1.addField("owningItem", (Object)item.getID());
                    SolrLogger.storeParents(doc1, (DSpaceObject)item);
                }
            }
        }
    }

    public static boolean isUseProxies() {
        return useProxies;
    }

    public static void removeIndex(String query) throws IOException, SolrServerException {
        solr.deleteByQuery(query);
        solr.commit();
    }

    public static Map<String, List<String>> queryField(String query, List oldFieldVals, String field) {
        HashMap<String, List<String>> currentValsStored = new HashMap<String, List<String>>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "1");
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = solr.query((SolrParams)solrParams);
            if (response.getResults().getNumFound() == 0L) {
                return currentValsStored;
            }
            SolrDocument document = (SolrDocument)response.getResults().get(0);
            for (String storedField : metadataStorageInfo.keySet()) {
                Collection collection = document.getFieldValues(storedField);
                ArrayList storedVals = new ArrayList();
                storedVals.addAll(collection);
                currentValsStored.put(storedField, storedVals);
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return currentValsStored;
    }

    public static void markRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            try {
                ResultProcessor processor = new ResultProcessor(){

                    @Override
                    public void process(SolrDocument doc) throws IOException, SolrServerException {
                        doc.removeFields("isBot");
                        doc.addField("isBot", (Object)true);
                        SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                        solr.add(newInput);
                        log.info((Object)("Marked " + doc.getFieldValue("ip") + " as bot"));
                    }
                };
                processor.execute("ip:" + ip + "* AND -isBot:true");
                solr.commit();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void markRobotByUserAgent(String agent) {
        try {
            ResultProcessor processor = new ResultProcessor(){

                @Override
                public void process(SolrDocument doc) throws IOException, SolrServerException {
                    doc.removeFields("isBot");
                    doc.addField("isBot", (Object)true);
                    SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                    solr.add(newInput);
                }
            };
            processor.execute("userAgent:" + agent + " AND -isBot:true");
            solr.commit();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteRobotsByIsBotFlag() {
        try {
            solr.deleteByQuery("isBot:true");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteIP(String ip) {
        try {
            solr.deleteByQuery("ip:" + ip + "*");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            SolrLogger.deleteIP(ip);
        }
    }

    public static void update(String query, String action, List<String> fieldNames, List<List<Object>> fieldValuesList) throws SolrServerException, IOException {
        final ArrayList docsToUpdate = new ArrayList();
        ResultProcessor processor = new ResultProcessor(){

            @Override
            public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
                docsToUpdate.addAll(docs);
            }
        };
        processor.execute(query);
        solr.deleteByQuery(query);
        for (int i = 0; i < docsToUpdate.size(); ++i) {
            SolrDocument solrDocument = (SolrDocument)docsToUpdate.get(i);
            for (int j = 0; j < fieldNames.size(); ++j) {
                String fieldName = fieldNames.get(j);
                List<Object> fieldValues = fieldValuesList.get(j);
                if (action.equals("addOne") || action.equals("replace")) {
                    if (action.equals("replace")) {
                        solrDocument.removeFields(fieldName);
                    }
                    for (Object fieldValue : fieldValues) {
                        solrDocument.addField(fieldName, fieldValue);
                    }
                    continue;
                }
                if (!action.equals("remOne")) continue;
                Collection values = solrDocument.getFieldValues(fieldName);
                solrDocument.removeFields(fieldName);
                for (Object value : values) {
                    if (fieldValues.contains(value)) continue;
                    solrDocument.addField(fieldName, value);
                }
            }
            SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)solrDocument);
            solr.add(newInput);
        }
        solr.commit();
    }

    public static void query(String query, int max) throws SolrServerException {
        SolrLogger.query(query, null, null, max, null, null, null, null);
    }

    public static ObjectCount[] queryFacetField(String query, String filterQuery, String facetField, int max, boolean showTotal, List<String> facetQueries) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, facetField, max, null, null, null, facetQueries);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField field = queryResponse.getFacetField(facetField);
        if (0 < field.getValueCount()) {
            ObjectCount[] result = new ObjectCount[field.getValueCount() + (showTotal ? 1 : 0)];
            for (int i = 0; i < field.getValues().size(); ++i) {
                FacetField.Count fieldCount = (FacetField.Count)field.getValues().get(i);
                result[i] = new ObjectCount();
                result[i].setCount(fieldCount.getCount());
                result[i].setValue(fieldCount.getName());
            }
            if (showTotal) {
                result[result.length - 1] = new ObjectCount();
                result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
                result[result.length - 1].setValue("total");
            }
            return result;
        }
        return new ObjectCount[0];
    }

    public static ObjectCount[] queryFacetDate(String query, String filterQuery, int max, String dateType, String dateStart, String dateEnd, boolean showTotal) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, null, max, dateType, dateStart, dateEnd, null);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField dateFacet = queryResponse.getFacetDate("time");
        ObjectCount[] result = new ObjectCount[dateFacet.getValueCount() + (showTotal ? 1 : 0)];
        for (int i = 0; i < dateFacet.getValues().size(); ++i) {
            FacetField.Count dateCount = (FacetField.Count)dateFacet.getValues().get(i);
            result[i] = new ObjectCount();
            result[i].setCount(dateCount.getCount());
            result[i].setValue(SolrLogger.getDateView(dateCount.getName(), dateType));
        }
        if (showTotal) {
            result[result.length - 1] = new ObjectCount();
            result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
            result[result.length - 1].setValue("total");
        }
        return result;
    }

    public static Map<String, Integer> queryFacetQuery(String query, String filterQuery, List<String> facetQueries) throws SolrServerException {
        QueryResponse response = SolrLogger.query(query, filterQuery, null, 1, null, null, null, facetQueries);
        return response.getFacetQuery();
    }

    public static ObjectCount queryTotal(String query, String filterQuery) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, null, -1, null, null, null, null);
        ObjectCount objCount = new ObjectCount();
        objCount.setCount(queryResponse.getResults().getNumFound());
        return objCount;
    }

    private static String getDateView(String name, String type) {
        if (name != null && name.matches("^[0-9]{4}\\-[0-9]{2}.*")) {
            Date date = null;
            try {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_8601);
                date = format.parse(name);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DCDATE);
                    date = format.parse(name);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            String dateformatString = "dd-MM-yyyy";
            if ("DAY".equals(type)) {
                dateformatString = "dd-MM-yyyy";
            } else if ("MONTH".equals(type)) {
                dateformatString = "MMMM yyyy";
            } else if ("YEAR".equals(type)) {
                dateformatString = "yyyy";
            }
            SimpleDateFormat simpleFormat = new SimpleDateFormat(dateformatString);
            if (date != null) {
                name = simpleFormat.format(date);
            }
        }
        return name;
    }

    private static QueryResponse query(String query, String filterQuery, String facetField, int max, String dateType, String dateStart, String dateEnd, List<String> facetQueries) throws SolrServerException {
        if (solr == null) {
            return null;
        }
        SolrQuery solrQuery = new SolrQuery().setRows(Integer.valueOf(0)).setQuery(query).setFacetMinCount(1);
        if (dateType != null) {
            solrQuery.setParam("facet.date", new String[]{"time"}).setParam("facet.date.end", new String[]{"NOW/" + dateType + dateEnd + dateType}).setParam("facet.date.gap", new String[]{"+1" + dateType}).setParam("facet.date.start", new String[]{"NOW/" + dateType + dateStart + dateType + "S"}).setFacet(true);
        }
        if (facetQueries != null) {
            for (int i = 0; i < facetQueries.size(); ++i) {
                String facetQuery = facetQueries.get(i);
                solrQuery.addFacetQuery(facetQuery);
            }
            if (0 < facetQueries.size()) {
                solrQuery.setFacet(true);
            }
        }
        if (facetField != null) {
            solrQuery.addFacetField(new String[]{facetField});
        }
        if (max != -1) {
            solrQuery.setFacetLimit(max);
        }
        if (ConfigurationManager.getBooleanProperty((String)"solr.statistics.query.filter.spiderIp", (boolean)false)) {
            solrQuery.addFilterQuery(new String[]{SolrLogger.getIgnoreSpiderIPs()});
        }
        if (ConfigurationManager.getBooleanProperty((String)"solr.statistics.query.filter.isBot", (boolean)true)) {
            solrQuery.addFilterQuery(new String[]{"-isBot:true"});
        }
        if (filterQuery != null) {
            solrQuery.addFilterQuery(new String[]{filterQuery});
        }
        QueryResponse response = null;
        try {
            response = solr.query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            System.err.println("Error using query " + query);
            throw e;
        }
        return response;
    }

    public static String getIgnoreSpiderIPs() {
        if (filterQuery == null) {
            StringBuilder query = new StringBuilder();
            boolean first = true;
            for (String ip : SpiderDetector.getSpiderIpAddresses()) {
                if (first) {
                    query.append(" AND ");
                    first = false;
                }
                query.append(" NOT(ip: ").append(ip).append(")");
            }
            filterQuery = query.toString();
        }
        return filterQuery;
    }

    public static void optimizeSOLR() {
        try {
            long start = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Started:" + start);
            solr.optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    static {
        String metadataVal;
        log = Logger.getLogger(SolrLogger.class);
        log.info((Object)("solr.spidersfile:" + ConfigurationManager.getProperty((String)"solr.spidersfile")));
        log.info((Object)("solr.log.server:" + ConfigurationManager.getProperty((String)"solr.log.server")));
        log.info((Object)("solr.dbfile:" + ConfigurationManager.getProperty((String)"solr.dbfile")));
        CommonsHttpSolrServer server = null;
        if (ConfigurationManager.getProperty((String)"solr.log.server") != null) {
            try {
                server = new CommonsHttpSolrServer(ConfigurationManager.getProperty((String)"solr.log.server"));
                SolrQuery solrQuery = new SolrQuery().setQuery("type:2 AND id:1");
                server.query((SolrParams)solrQuery);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        solr = server;
        LookupService service = null;
        String dbfile = ConfigurationManager.getProperty((String)"solr.dbfile");
        if (dbfile != null) {
            try {
                service = new LookupService(dbfile, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        locationService = service;
        useProxies = "true".equals(ConfigurationManager.getProperty((String)"useProxies"));
        log.info((Object)("useProxies=" + useProxies));
        metadataStorageInfo = new HashMap<String, String>();
        int count = 1;
        while ((metadataVal = ConfigurationManager.getProperty((String)("solr.metadata.item." + count))) != null) {
            String storeVal = metadataVal.split(":")[0];
            String metadataField = metadataVal.split(":")[1];
            metadataStorageInfo.put(storeVal, metadataField);
            log.info((Object)("solr.metadata.item." + count + "=" + metadataVal));
            ++count;
        }
        filterQuery = null;
    }

    public static class ResultProcessor {
        public void execute(String query) throws SolrServerException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "10");
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = solr.query((SolrParams)solrParams);
            long numbFound = response.getResults().getNumFound();
            this.process((List<SolrDocument>)response.getResults());
            int i = 10;
            while ((long)i < numbFound) {
                params.put("start", String.valueOf(i));
                solrParams = new MapSolrParams(params);
                response = solr.query((SolrParams)solrParams);
                this.process((List<SolrDocument>)response.getResults());
                i += 10;
            }
        }

        public void commit() throws IOException, SolrServerException {
            solr.commit();
        }

        public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
            for (SolrDocument doc : docs) {
                this.process(doc);
            }
        }

        public void process(SolrDocument doc) throws IOException, SolrServerException {
        }
    }
}

