/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.statistics.SolrLogger;

public class StatisticsLoggingConsumer
implements Consumer {
    private Set<String> toRemoveQueries = null;

    public void initialize() throws Exception {
    }

    public void consume(Context ctx, Event event) throws Exception {
        ArrayList<Object> valsList;
        ArrayList<List<Object>> valuesList;
        ArrayList<String> fieldNames;
        Item newItem;
        String updateQuery;
        if (this.toRemoveQueries == null) {
            this.toRemoveQueries = new HashSet<String>();
        }
        int dsoId = event.getSubjectID();
        int dsoType = event.getSubjectType();
        int eventType = event.getEventType();
        if (eventType == 32) {
            String query = "id:" + dsoId + " AND type:" + dsoType;
            this.toRemoveQueries.add(query);
        } else if ((eventType != 2 || dsoType != 2) && eventType == 4 && event.getSubjectType() == 2) {
            Item item = Item.find((Context)ctx, (int)event.getSubjectID());
            updateQuery = "id:" + item.getID() + " AND type:" + item.getType();
            Map<String, List<String>> indexedValues = SolrLogger.queryField(updateQuery, null, null);
            Map<String, String> metadataStorageInfo = SolrLogger.getMetadataStorageInfo();
            ArrayList<String> storageFieldList = new ArrayList<String>();
            ArrayList<List<Object>> storageValuesList = new ArrayList<List<Object>>();
            for (Map.Entry<String, String> entry : metadataStorageInfo.entrySet()) {
                String[] metadataFieldInfo = entry.getValue().split("\\.");
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<String> valuesLow = new ArrayList<String>();
                for (int i = 0; i < item.getMetadata(metadataFieldInfo[0], metadataFieldInfo[1], metadataFieldInfo[2], "*").length; ++i) {
                    values.add(item.getMetadata((String)metadataFieldInfo[0], (String)metadataFieldInfo[1], (String)metadataFieldInfo[2], (String)"*")[i].value);
                    valuesLow.add(item.getMetadata((String)metadataFieldInfo[0], (String)metadataFieldInfo[1], (String)metadataFieldInfo[2], (String)"*")[i].value.toLowerCase());
                }
                List<String> indexedVals = indexedValues.get(entry.getKey());
                boolean update = true;
                if (values.size() == indexedVals.size() && values.containsAll(indexedVals)) {
                    update = false;
                }
                if (!update) continue;
                storageFieldList.add(entry.getKey());
                storageFieldList.add(entry.getKey() + "_search");
                storageValuesList.add(values);
                storageValuesList.add(valuesLow);
            }
            SolrLogger.update(updateQuery, "replace", storageFieldList, storageValuesList);
        }
        if (eventType == 8 && dsoType == 3 && event.getObject(ctx) instanceof Item) {
            newItem = (Item)event.getObject(ctx);
            updateQuery = "id: " + newItem.getID() + " AND type:" + newItem.getType();
            fieldNames = new ArrayList<String>();
            valuesList = new ArrayList<List<Object>>();
            fieldNames.add("owningColl");
            fieldNames.add("owningComm");
            valsList = new ArrayList<Object>();
            valsList.add(dsoId);
            valuesList.add(valsList);
            valsList = new ArrayList();
            valsList.addAll(this.findOwningCommunities(ctx, dsoId));
            valuesList.add(valsList);
            SolrLogger.update(updateQuery, "addOne", fieldNames, valuesList);
        } else if (eventType == 16 && dsoType == 3 && event.getObject(ctx) instanceof Item) {
            newItem = (Item)event.getObject(ctx);
            updateQuery = "id: " + newItem.getID() + " AND type:" + newItem.getType();
            fieldNames = new ArrayList();
            valuesList = new ArrayList();
            fieldNames.add("owningColl");
            fieldNames.add("owningComm");
            valsList = new ArrayList();
            valsList.add(dsoId);
            valuesList.add(valsList);
            valsList = new ArrayList();
            valsList.addAll(this.findOwningCommunities(ctx, dsoId));
            valuesList.add(valsList);
            SolrLogger.update(updateQuery, "remOne", fieldNames, valuesList);
        }
    }

    private List<Object> findOwningCommunities(Context context, int collId) throws SQLException {
        Collection coll = Collection.find((Context)context, (int)collId);
        ArrayList<Object> owningComms = new ArrayList<Object>();
        for (int i = 0; i < coll.getCommunities().length; ++i) {
            Community community = coll.getCommunities()[i];
            this.findComms(community, owningComms);
        }
        return owningComms;
    }

    private void findComms(Community comm, List<Object> parentComms) throws SQLException {
        if (comm == null) {
            return;
        }
        if (!parentComms.contains(comm.getID())) {
            parentComms.add(comm.getID());
        }
        this.findComms(comm.getParentCommunity(), parentComms);
    }

    public void end(Context ctx) throws Exception {
        if (this.toRemoveQueries != null) {
            for (String query : this.toRemoveQueries) {
                SolrLogger.removeIndex(query);
            }
        }
        this.toRemoveQueries = null;
    }

    public void finish(Context ctx) throws Exception {
    }
}

