/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.statistics.util.SpiderDetector;

public class ApacheLogRobotsProcessor {
    public static void main(String[] args) throws Exception {
        String logLine;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("l", "logfile", true, "type: Input log file");
        options.addOption("s", "spiderfile", true, "type: Spider IP file");
        CommandLine line = parser.parse(options, args);
        if (!line.hasOption("l")) {
            System.out.println("We need our log file");
            return;
        }
        String logFileLoc = line.getOptionValue("l");
        if (!line.hasOption("s")) {
            System.out.println("We need a spider IP output file");
            return;
        }
        String spiderIpPath = line.getOptionValue("s");
        File spiderIpFile = new File(spiderIpPath);
        Set<String> logSpiders = spiderIpFile.exists() ? SpiderDetector.readIpAddresses(spiderIpFile) : new HashSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(logFileLoc));
        while ((logLine = in.readLine()) != null) {
            if (!logLine.contains("robots.txt")) continue;
            String ip = logLine.substring(0, logLine.indexOf(45)).trim();
            logSpiders.add(ip);
        }
        in.close();
        BufferedWriter output = new BufferedWriter(new FileWriter(spiderIpFile));
        for (String ip : logSpiders) {
            System.out.println("Adding new ip: " + ip);
            output.write(ip + "\n");
        }
        output.flush();
        output.close();
    }
}

