/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositManager;
import org.dspace.sword.SWORDAuthentication;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceDocumentRequest;
import org.purl.sword.server.SWORDServer;

public class DSpaceSWORDServer
implements SWORDServer {
    public static Logger log = Logger.getLogger(DSpaceSWORDServer.class);
    private Context context;

    public ServiceDocument doServiceDocument(ServiceDocumentRequest request) throws SWORDAuthenticationException, SWORDException {
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader((Context)this.context, (String)"sword_do_service_document", (String)""));
        }
        try {
            ServiceDocument doc;
            SWORDContext sc = this.authenticate(request);
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_service_document_request", (String)("username=" + request.getUsername() + ",on_behalf_of=" + request.getOnBehalfOf())));
            SWORDService service = new SWORDService();
            service.setContext(this.context);
            service.setSWORDContext(sc);
            ServiceDocument serviceDocument = doc = service.getServiceDocument();
            return serviceDocument;
        }
        catch (DSpaceSWORDException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("The DSpace SWORD interface experienced an error", e);
        }
        finally {
            if (this.context != null) {
                this.context.abort();
            }
        }
    }

    public DepositResponse doDeposit(Deposit deposit) throws SWORDAuthenticationException, SWORDException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)this.context, (String)"sword_do_deposit", (String)""));
            }
            SWORDContext sc = this.authenticate(deposit);
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_deposit_request", (String)("username=" + deposit.getUsername() + ",on_behalf_of=" + deposit.getOnBehalfOf())));
            DepositManager dm = new DepositManager();
            dm.setContext(this.context);
            dm.setDeposit(deposit);
            dm.setSWORDContext(sc);
            DepositResponse response = dm.deposit();
            if (this.context != null && this.context.isValid()) {
                this.context.commit();
            }
            DepositResponse depositResponse = response;
            return depositResponse;
        }
        catch (DSpaceSWORDException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SWORDAuthenticationException("There was a problem depositing the item", e);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem completing the transaction", e);
        }
        finally {
            if (this.context != null && this.context.isValid()) {
                this.context.abort();
            }
        }
    }

    private void constructContext(String ip) throws SWORDException {
        try {
            this.context = new Context();
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem with the database", e);
        }
        this.context.setExtraLogInfo("session_id=0:ip_addr=" + ip);
    }

    private SWORDContext authenticate(ServiceDocumentRequest request) throws SWORDAuthenticationException, SWORDException {
        this.constructContext(request.getIPAddress());
        return this.authenticate(request.getUsername(), request.getPassword(), request.getOnBehalfOf());
    }

    private SWORDContext authenticate(Deposit deposit) throws SWORDAuthenticationException, SWORDException {
        this.constructContext(deposit.getIPAddress());
        return this.authenticate(deposit.getUsername(), deposit.getPassword(), deposit.getOnBehalfOf());
    }

    private SWORDContext authenticate(String un, String pw, String obo) throws SWORDAuthenticationException, SWORDException {
        if ("".equals(obo)) {
            obo = null;
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_authenticate", (String)("username=" + un + ",on_behalf_of=" + obo)));
        try {
            SWORDContext sc = new SWORDContext();
            SWORDAuthentication auth = new SWORDAuthentication();
            EPerson ep = null;
            boolean authenticated = false;
            if (auth.authenticates(this.context, un, pw)) {
                ep = EPerson.findByEmail((Context)this.context, (String)un);
                if (ep != null) {
                    authenticated = true;
                    sc.setAuthenticated(ep);
                }
                if (obo != null) {
                    EPerson epObo = EPerson.findByEmail((Context)this.context, (String)obo);
                    if (epObo != null) {
                        sc.setOnBehalfOf(epObo);
                    } else {
                        authenticated = false;
                    }
                }
            }
            if (ep == null || !authenticated) {
                if (ep != null) {
                    log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_unable_to_set_user", (String)("username=" + un)));
                    throw new SWORDAuthenticationException("Unable to authenticate the supplied used");
                }
                log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_unable_to_set_on_behalf_of", (String)("username=" + un + ",on_behalf_of=" + obo)));
                throw new SWORDAuthenticationException("Unable to authenticate the onBehalfOf account");
            }
            this.context.setCurrentUser(ep);
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"sword_set_authenticated_user", (String)("user_id=" + ep.getID())));
            return sc;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem accessing the repository user database", e);
        }
        catch (AuthorizeException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDAuthenticationException("There was a problem authenticating or authorising the user", (Exception)((Object)e));
        }
    }
}

