/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword.CollectionLocation;
import org.dspace.sword.DSpaceATOMEntry;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDIngesterFactory;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;

public class DepositManager {
    public static Logger log = Logger.getLogger(DepositManager.class);
    private Context context;
    private Deposit deposit;
    private SWORDContext swordContext;

    public void setContext(Context context) {
        this.context = context;
    }

    public void setDeposit(Deposit deposit) {
        this.deposit = deposit;
    }

    public void setSWORDContext(SWORDContext sc) {
        this.swordContext = sc;
    }

    public DepositResponse deposit() throws DSpaceSWORDException {
        Date start = new Date();
        StringBuilder verbs = new StringBuilder();
        if (this.deposit.isVerbose()) {
            verbs.append(start.toString() + "; \n\n");
            verbs.append("Initialising verbose deposit; \n\n");
        }
        if (!this.canSubmit()) {
            String oboEmail = "none";
            if (this.swordContext.getOnBehalfOf() != null) {
                oboEmail = this.swordContext.getOnBehalfOf().getEmail();
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"deposit_failed_authorisation", (String)("user=" + this.swordContext.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
            throw new DSpaceSWORDException("Cannot submit to the given collection with this context");
        }
        if (this.deposit.isVerbose()) {
            verbs.append("Authenticated user " + this.swordContext.getAuthenticated().getEmail() + "; \n\n");
            if (this.swordContext.getOnBehalfOf() != null) {
                verbs.append("Depositing on behalf of: " + this.swordContext.getOnBehalfOf().getEmail() + "; \n\n");
            }
        }
        SWORDIngester si = SWORDIngesterFactory.getInstance(this.context, this.deposit);
        DepositResult result = si.ingest(this.context, this.deposit);
        String handle = result.getHandle();
        int state = 201;
        if (handle == null || "".equals(handle)) {
            state = 202;
        }
        DepositResponse response = new DepositResponse(state);
        DSpaceATOMEntry dsatom = new DSpaceATOMEntry();
        SWORDEntry entry = dsatom.getSWORDEntry(result.getItem(), handle, this.deposit.isNoOp());
        String nooplog = "";
        if (this.deposit.isNoOp()) {
            this.undoDeposit(result);
            nooplog = "NoOp Requested: Removed all traces of submission; \n\n";
        }
        entry.setNoOp(this.deposit.isNoOp());
        if (this.deposit.isVerbose()) {
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            String timer = "Total time for deposit processing: " + delta + " ms;";
            String verboseness = result.getVerboseDescription();
            if (verboseness != null && !"".equals(verboseness)) {
                entry.setVerboseDescription(verbs.toString() + result.getVerboseDescription() + nooplog + timer);
            }
        }
        response.setEntry(entry);
        return response;
    }

    private boolean canSubmit() throws DSpaceSWORDException {
        String loc = this.deposit.getLocation();
        CollectionLocation cl = new CollectionLocation();
        Collection collection = cl.getCollection(this.context, loc);
        boolean submit = this.swordContext.canSubmitTo(this.context, collection);
        return submit;
    }

    private void verify() throws DSpaceSWORDException {
    }

    private void undoDeposit(DepositResult result) throws DSpaceSWORDException {
        try {
            Item item = result.getItem();
            Collection collection = item.getOwningCollection();
            collection.removeItem(item);
            if (this.context != null && this.context.isValid()) {
                this.context.abort();
            }
        }
        catch (IOException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
        catch (AuthorizeException e) {
            log.error((Object)"authentication problem; caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }
}

