/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.sword.CollectionLocation;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDContext;
import org.purl.sword.base.Collection;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceLevel;
import org.purl.sword.base.Workspace;

public class SWORDService {
    public static Logger log = Logger.getLogger(SWORDService.class);
    private Context context = null;
    private SWORDContext swordContext = null;

    public void setContext(Context context) {
        this.context = context;
    }

    public void setSWORDContext(SWORDContext sc) {
        this.swordContext = sc;
    }

    public ServiceDocument getServiceDocument() throws DSpaceSWORDException {
        if (this.context == null) {
            throw new DSpaceSWORDException("The Context is null; please set it before calling getServiceDocument");
        }
        if (this.swordContext == null) {
            throw new DSpaceSWORDException("The SWORD Context is null; please set it before calling getServiceDocument");
        }
        ServiceLevel sl = ServiceLevel.ONE;
        boolean noOp = true;
        boolean verbose = true;
        Service service = new Service(sl, noOp, verbose);
        String ws = ConfigurationManager.getProperty((String)"dspace.name");
        Workspace workspace = new Workspace();
        workspace.setTitle(ws);
        org.dspace.content.Collection[] cols = this.swordContext.getAllowedCollections(this.context);
        for (int i = 0; i < cols.length; ++i) {
            Collection scol = this.buildSwordCollection(cols[i]);
            workspace.addCollection(scol);
        }
        service.addWorkspace(workspace);
        ServiceDocument sd = new ServiceDocument(service);
        return sd;
    }

    private boolean isAdmin(EPerson eperson) throws SQLException {
        Group admin = Group.find((Context)this.context, (int)1);
        return admin.isMember(eperson);
    }

    private boolean isInGroup(Group group, EPerson eperson) {
        EPerson[] eps = group.getMembers();
        Group[] groups = group.getMemberGroups();
        for (int i = 0; i < eps.length; ++i) {
            if (eperson.getID() != eps[i].getID()) continue;
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (int j = 0; j < groups.length; ++j) {
                if (!this.isInGroup(groups[j], eperson)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection buildSwordCollection(org.dspace.content.Collection col) throws DSpaceSWORDException {
        Collection scol = new Collection();
        CollectionLocation cl = new CollectionLocation();
        String location = cl.getLocation(col);
        String title = col.getMetadata("name");
        String collectionPolicy = col.getLicense();
        String namespace = "http://www.loc.gov/METS";
        String dcAbstract = col.getMetadata("short_description");
        boolean mediation = true;
        String zip = "application/zip";
        scol.setLocation(location);
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if (collectionPolicy != null && !"".equals(collectionPolicy)) {
            scol.setCollectionPolicy(collectionPolicy);
        }
        if (dcAbstract != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(mediation);
        scol.addAccepts(zip);
        scol.setFormatNamespace(namespace);
        return scol;
    }
}

