/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.UnmarshallException;

public class DepositResponse {
    private SWORDEntry entry = new SWORDEntry();
    private int httpResponse;

    public DepositResponse(int httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setEntry(SWORDEntry entry) {
        this.entry = entry;
    }

    public SWORDEntry getEntry() {
        return this.entry;
    }

    public int getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(int httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String marshall() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)stream, "UTF-8");
            serializer.setIndent(3);
            serializer.setMaxLength(64);
            if (this.entry != null) {
                Document doc = new Document(this.entry.marshall());
                serializer.write(doc);
                System.out.println(stream.toString());
                return stream.toString();
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return null;
    }

    public void unmarshall(String xml) throws UnmarshallException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(xml, "http://something.com/here");
            Element root = doc.getRootElement();
            this.entry = new SWORDEntry();
            this.entry.unmarshall(root);
        }
        catch (ParsingException ex) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new UnmarshallException("Error acessing the file?", ex);
        }
    }

    public String toString() {
        return this.marshall();
    }
}

