/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.test;

import org.purl.sword.base.Collection;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceLevel;
import org.purl.sword.base.Workspace;
import org.w3.atom.Author;
import org.w3.atom.Content;
import org.w3.atom.ContentType;
import org.w3.atom.Contributor;
import org.w3.atom.Generator;
import org.w3.atom.Link;
import org.w3.atom.Rights;
import org.w3.atom.Source;
import org.w3.atom.Title;

public class SwordTest {
    public static void main(String[] args) {
        SwordTest test = new SwordTest();
        test.serviceDocumentTest();
        test.depositResponseTest();
    }

    public void serviceDocumentTest() {
        Service service = new Service(ServiceLevel.ZERO);
        service.setVerbose(true);
        service.setNoOp(false);
        Workspace workspace = new Workspace();
        workspace.setTitle("This is a test");
        Collection collection = new Collection();
        collection.setTitle("The first collection");
        collection.setLocation("http://www.somewhere.com/here");
        workspace.addCollection(collection);
        service.addWorkspace(workspace);
        workspace = new Workspace();
        workspace.setTitle("This is a second test");
        collection = new Collection();
        collection.setTitle("The second collection");
        collection.setLocation("http://www.somewhere.com/here/something");
        collection.addAccepts("application/zip");
        collection.addAccepts("application/xml");
        collection.setAbstract("An abstract goes in here");
        collection.setCollectionPolicy("A collection policy");
        collection.setMediation(true);
        collection.setFormatNamespace("a namespace in here");
        collection.setTreatment("treatment in here too");
        workspace.addCollection(collection);
        service.addWorkspace(workspace);
        ServiceDocument document = new ServiceDocument(service);
        String doc = document.marshall();
        System.out.println(doc);
        try {
            ServiceDocument unmarshalledDocument = new ServiceDocument();
            unmarshalledDocument.unmarshall(doc);
            System.out.println(unmarshalledDocument.marshall());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void depositResponseTest() {
        try {
            DepositResponse response = new DepositResponse(202);
            SWORDEntry entry = new SWORDEntry();
            entry.setId("atom:com.intrallect.atomTest3p0:60");
            Title title = new Title();
            title.setContent("Burning Stubble");
            title.setType(ContentType.TEXT);
            entry.setTitle(title);
            Author author = new Author();
            author.setName("Sword Tester");
            author.setEmail("sword@ukoln.ac.uk");
            author.setUri("http://www.ukoln.ac.uk/repositories/digirep/index/SWORD");
            entry.addAuthors(author);
            author = new Author();
            author.setName("CASIS Tester");
            author.setEmail("nst@aber.ac.uk");
            author.setUri("http://www.aber.ac.uk/casis/");
            entry.addAuthors(author);
            Link link = new Link();
            link.setRel("edit-media");
            link.setHref("http://bagel.intrallect.com:5555/intralibrary3p0/IntraLibrary-Deposit/edit-media/learning_object_id60");
            link.setHreflang("en");
            link.setTitle("Edit Media Title");
            link.setType("edit media type");
            link.setContent("some content in here");
            entry.addLink(link);
            link = new Link();
            link.setRel("edit");
            link.setHref("http://bagel.intrallect.com:5555/intralibrary3p0/IntraLibrary-Deposit/edit/learning_object_id60");
            link.setHreflang("en");
            link.setTitle("Edit Title");
            link.setType("edit type");
            link.setContent("some content in here");
            entry.addLink(link);
            entry.addCategory("test category");
            entry.addCategory("second test category");
            Contributor contributor = new Contributor();
            contributor.setName("Neil Taylor");
            contributor.setEmail("nst@aber.ac.uk");
            contributor.setUri("http://www.aber.ac.uk/casis/");
            entry.addContributor(contributor);
            Rights rights = new Rights();
            rights.setType(ContentType.TEXT);
            rights.setContent("Rights declaration.");
            entry.setRights(rights);
            Content content = new Content();
            content.setSource("http://bagel.intrallect.com:5555/intralibrary3p0/IntraLibrary?command=open-preview&amp;learning_object_key=i189n4207t");
            content.setType("application/zip");
            entry.setContent(content);
            Generator generator = new Generator();
            generator.setContent("Test Generator ID");
            generator.setUri("http://www.somewhere.com/");
            generator.setVersion("1.1");
            Source source = new Source();
            source.setGenerator(generator);
            entry.setSource(source);
            entry.setPublished("2007-08-02T10:13:14Z");
            entry.setUpdated("2007-08-02T10:22:17Z");
            entry.setFormatNamespace("Test format namespace");
            entry.setTreatment("Treatment description");
            entry.setNoOp(true);
            entry.setVerboseDescription("A Verbose Description.");
            response.setEntry(entry);
            String test = response.marshall();
            System.out.println(test);
            System.out.println("=================");
            DepositResponse unmarshalledDocument = new DepositResponse(201);
            unmarshalledDocument.unmarshall(test);
            System.out.println(unmarshalledDocument.marshall());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

