/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import nu.xom.Attribute;
import nu.xom.Element;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.InvalidMediaTypeException;

public class Content
extends XmlElement
implements SwordElementInterface {
    public static final String ATTR_SRC = "src";
    public static final String ATTR_TYPE = "type";
    private String type;
    private String source;

    public Content() {
        super("atom", "content");
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidMediaTypeException {
        if (type == null || !type.matches(".*/.*")) {
            throw new InvalidMediaTypeException("Type: '" + type + "' does not match .*/.*");
        }
        this.type = type;
    }

    public Element marshall() {
        Attribute typeAttribute;
        Element content = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.type != null) {
            typeAttribute = new Attribute(ATTR_TYPE, this.type);
            content.addAttribute(typeAttribute);
        }
        if (this.source != null) {
            typeAttribute = new Attribute(ATTR_SRC, this.source);
            content.addAttribute(typeAttribute);
        }
        return content;
    }

    public void unmarshall(Element content) throws UnmarshallException {
        if (!this.isInstanceOf(content, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Element is not of the correct type");
        }
        try {
            int attributeCount = content.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = content.getAttribute(i);
                String name = attribute.getQualifiedName();
                if (ATTR_TYPE.equals(name)) {
                    this.type = attribute.getValue();
                }
                if (!ATTR_SRC.equals(name)) continue;
                this.source = attribute.getValue();
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Content: " + ex.getMessage());
            throw new UnmarshallException("Error parsing Content", ex);
        }
    }
}

