/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import nu.xom.Attribute;
import nu.xom.Element;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;

public class Generator
extends XmlElement
implements SwordElementInterface {
    private String content;
    private String uri;
    private String version;

    public Generator() {
        super("atom", "generator");
    }

    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.content != null) {
            element.appendChild(this.content);
        }
        if (this.uri != null) {
            Attribute uriAttribute = new Attribute("uri", this.uri);
            element.addAttribute(uriAttribute);
        }
        if (this.version != null) {
            Attribute versionAttribute = new Attribute("version", this.version);
            element.addAttribute(versionAttribute);
        }
        return element;
    }

    public void unmarshall(Element generator) throws UnmarshallException {
        if (!this.isInstanceOf(generator, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Not an atom:generator element");
        }
        try {
            int attributeCount = generator.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = generator.getAttribute(i);
                if ("uri".equals(attribute.getQualifiedName())) {
                    this.uri = attribute.getValue();
                    continue;
                }
                if (!"version".equals(attribute.getQualifiedName())) continue;
                this.version = attribute.getValue();
            }
            int length = generator.getChildCount();
            if (length > 0) {
                this.content = this.unmarshallString(generator);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Generator: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse element in Generator", ex);
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

