/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;

public class Link
extends XmlElement
implements SwordElementInterface {
    private String href;
    private String rel;
    private String type;
    private String hreflang;
    private String title;
    private String length;
    private String content;

    public Link() {
        super("atom", "link");
    }

    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.content != null) {
            element.appendChild(this.content);
        }
        if (this.href != null) {
            Attribute hrefAttribute = new Attribute("href", this.href);
            element.addAttribute(hrefAttribute);
        }
        if (this.rel != null) {
            Attribute relAttribute = new Attribute("rel", this.rel);
            element.addAttribute(relAttribute);
        }
        if (this.type != null) {
            Attribute typeAttribute = new Attribute("type", this.type);
            element.addAttribute(typeAttribute);
        }
        if (this.hreflang != null) {
            Attribute hreflangAttribute = new Attribute("hreflang", this.hreflang);
            element.addAttribute(hreflangAttribute);
        }
        if (this.title != null) {
            Attribute titleAttribute = new Attribute("title", this.title);
            element.addAttribute(titleAttribute);
        }
        if (this.length != null) {
            Attribute lengthAttribute = new Attribute("length", this.length);
            element.addAttribute(lengthAttribute);
        }
        return element;
    }

    public void unmarshall(Element link) throws UnmarshallException {
        if (!this.isInstanceOf(link, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Not an atom:link element");
        }
        try {
            int attributeCount = link.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = link.getAttribute(i);
                if ("href".equals(attribute.getQualifiedName())) {
                    this.href = attribute.getValue();
                    continue;
                }
                if ("rel".equals(attribute.getQualifiedName())) {
                    this.rel = attribute.getValue();
                    continue;
                }
                if ("type".equals(attribute.getQualifiedName())) {
                    this.type = attribute.getValue();
                    continue;
                }
                if ("hreflang".equals(attribute.getQualifiedName())) {
                    this.hreflang = attribute.getValue();
                    continue;
                }
                if ("title".equals(attribute.getQualifiedName())) {
                    this.title = attribute.getValue();
                    continue;
                }
                if (!"length".equals(attribute.getQualifiedName())) continue;
                this.length = attribute.getValue();
            }
            Elements elements = link.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                this.content = this.unmarshallString(element);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Link: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse element in link", ex);
        }
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public void setHreflang(String hreflang) {
        this.hreflang = hreflang;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

