/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.Generator;

public class Source
extends XmlElement
implements SwordElementInterface {
    private Generator generator;

    public Source() {
        super("atom", "source");
    }

    public Element marshall() {
        Element source = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.generator != null) {
            source.appendChild((Node)this.generator.marshall());
        }
        return source;
    }

    public void unmarshall(Element source) throws UnmarshallException {
        if (!this.isInstanceOf(source, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Not an atom:source element");
        }
        try {
            Elements elements = source.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (!this.isInstanceOf(element, "generator", "http://www.w3.org/2005/Atom")) continue;
                this.generator = new Generator();
                this.generator.unmarshall(element);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Source: " + ex.getMessage());
            ex.printStackTrace();
            throw new UnmarshallException("Unable to parse an element in Source", ex);
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }
}

