/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.sword.DSpaceSWORDException;

public class SWORDContext {
    private EPerson authenticated = null;
    private EPerson onBehalfOf = null;

    public EPerson getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(EPerson authenticated) {
        this.authenticated = authenticated;
    }

    public EPerson getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(EPerson onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public boolean isUserAdmin(Context context) throws DSpaceSWORDException {
        try {
            if (this.authenticated != null) {
                Group admin = Group.find((Context)context, (int)1);
                return admin.isMember(this.authenticated);
            }
            return false;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean isOnBehalfOfAdmin(Context context) throws DSpaceSWORDException {
        try {
            if (this.onBehalfOf != null) {
                Group admin = Group.find((Context)context, (int)1);
                return admin.isMember(this.onBehalfOf);
            }
            return false;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean isUserInGroup(Group group) {
        if (this.authenticated != null) {
            return this.isInGroup(group, this.authenticated);
        }
        return false;
    }

    public boolean isOnBehalfOfInGroup(Group group) {
        if (this.onBehalfOf != null) {
            return this.isInGroup(group, this.onBehalfOf);
        }
        return false;
    }

    public boolean isInGroup(Group group, EPerson eperson) {
        EPerson[] eps = group.getMembers();
        Group[] groups = group.getMemberGroups();
        for (int i = 0; i < eps.length; ++i) {
            if (eperson.getID() != eps[i].getID()) continue;
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (int j = 0; j < groups.length; ++j) {
                if (!this.isInGroup(groups[j], eperson)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection[] getAllowedCollections(Context context) throws DSpaceSWORDException {
        try {
            Collection[] cols = Collection.findAuthorized((Context)context, null, (int)3);
            if (this.getOnBehalfOf() == null) {
                return cols;
            }
            if (this.isOnBehalfOfAdmin(context)) {
                return cols;
            }
            ArrayList<Collection> colList = new ArrayList<Collection>();
            for (int i = 0; i < cols.length; ++i) {
                Group subs = cols[i].getSubmitters();
                if (!this.isOnBehalfOfInGroup(subs)) continue;
                colList.add(cols[i]);
            }
            Collection[] newCols = new Collection[colList.size()];
            newCols = colList.toArray(newCols);
            return newCols;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean canSubmitTo(Context context, Collection collection) throws DSpaceSWORDException {
        Group subs = collection.getSubmitters();
        if (this.isUserAdmin(context)) {
            if (this.onBehalfOf != null) {
                if (this.isOnBehalfOfAdmin(context)) {
                    return true;
                }
                return this.isOnBehalfOfInGroup(subs);
            }
            return true;
        }
        if (this.isUserInGroup(subs)) {
            if (this.onBehalfOf != null) {
                if (this.isOnBehalfOfAdmin(context)) {
                    return true;
                }
                return this.isOnBehalfOfInGroup(subs);
            }
            return true;
        }
        return false;
    }
}

