/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.ContentType;
import org.w3.atom.Title;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
extends XmlElement
implements SwordElementInterface {
    public static final String ELEMENT_NAME = "collection";
    private String location;
    private Title title;
    private List<String> accepts;
    private String collectionPolicy;
    private boolean mediation;
    private boolean mediationSet;
    private String treatment;
    private String namespace;
    private String dcAbstract;

    public Collection() {
        super(null);
        this.accepts = new ArrayList<String>();
        this.mediationSet = false;
    }

    public Collection(String location) {
        super(null);
        this.location = location;
    }

    public String[] getAccepts() {
        String[] values = new String[this.accepts.size()];
        return this.accepts.toArray(values);
    }

    public List<String> getAcceptsList() {
        return this.accepts;
    }

    public void addAccepts(String accepts) {
        this.accepts.add(accepts);
    }

    public void clearAccepts() {
        this.accepts.clear();
    }

    public String getCollectionPolicy() {
        return this.collectionPolicy;
    }

    public void setCollectionPolicy(String collectionPolicy) {
        this.collectionPolicy = collectionPolicy;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean getMediation() {
        return this.mediation;
    }

    public void setMediation(boolean mediation) {
        this.mediation = mediation;
        this.mediationSet = true;
    }

    public String getNamespace() {
        return this.getFormatNamespace();
    }

    public String getFormatNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.setFormatNamespace(namespace);
    }

    public void setFormatNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAbstract() {
        return this.dcAbstract;
    }

    public void setAbstract(String abstractString) {
        this.dcAbstract = abstractString;
    }

    public void setTitle(String title) {
        if (this.title == null) {
            this.title = new Title();
        }
        this.title.setContent(title);
        this.title.setType(ContentType.TEXT);
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getContent();
    }

    public String getTreatment() {
        return this.treatment;
    }

    public void setTreatment(String treatment) {
        this.treatment = treatment;
    }

    public String toString() {
        Element element = this.marshall();
        return element.toString();
    }

    @Override
    public Element marshall() {
        Element collection = new Element(ELEMENT_NAME, "http://purl.org/atom/app#");
        Attribute href = new Attribute("href", this.location);
        collection.addAttribute(href);
        collection.appendChild((Node)this.title.marshall());
        Element acceptsElement = null;
        for (String item : this.accepts) {
            acceptsElement = new Element("accepts", "http://purl.org/atom/app#");
            acceptsElement.appendChild(item);
            collection.appendChild((Node)acceptsElement);
        }
        if (this.collectionPolicy != null) {
            Element colPolicyElement = new Element("sword:collectionPolicy", "http://purl.org/net/sword/");
            colPolicyElement.appendChild(this.collectionPolicy);
            collection.appendChild((Node)colPolicyElement);
        }
        if (this.dcAbstract != null) {
            Element dcAbstractElement = new Element("dcterms:abstract", "http://purl.org/dc/terms/");
            dcAbstractElement.appendChild(this.dcAbstract);
            collection.appendChild((Node)dcAbstractElement);
        }
        if (this.mediationSet) {
            Element mediationElement = new Element("sword:mediation", "http://purl.org/net/sword/");
            mediationElement.appendChild(Boolean.toString(this.mediation));
            collection.appendChild((Node)mediationElement);
        }
        if (this.treatment != null) {
            Element treatmentElement = new Element("sword:treatment", "http://purl.org/net/sword/");
            treatmentElement.appendChild(this.treatment);
            collection.appendChild((Node)treatmentElement);
        }
        if (this.namespace != null) {
            Element namespaceElement = new Element("sword:namespace", "http://purl.org/net/sword/");
            namespaceElement.appendChild(this.namespace);
            collection.appendChild((Node)namespaceElement);
        }
        return collection;
    }

    @Override
    public void unmarshall(Element collection) throws UnmarshallException {
        if (!this.isInstanceOf(collection, ELEMENT_NAME, "http://purl.org/atom/app#")) {
            throw new UnmarshallException("Not an app:collection element");
        }
        try {
            int count = collection.getAttributeCount();
            Attribute a = null;
            for (int i = 0; i < count; ++i) {
                a = collection.getAttribute(i);
                if (!"href".equals(a.getQualifiedName())) continue;
                this.location = a.getValue();
            }
            this.accepts.clear();
            Elements elements = collection.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, "title", "http://www.w3.org/2005/Atom")) {
                    this.title = new Title();
                    this.title.unmarshall(element);
                    continue;
                }
                if (this.isInstanceOf(element, "accepts", "http://purl.org/atom/app#")) {
                    this.accepts.add(this.unmarshallString(element));
                    continue;
                }
                if (this.isInstanceOf(element, "collectionPolicy", "http://purl.org/net/sword/")) {
                    this.collectionPolicy = this.unmarshallString(element);
                    continue;
                }
                if (this.isInstanceOf(element, "abstract", "http://purl.org/dc/terms/")) {
                    this.dcAbstract = this.unmarshallString(element);
                    continue;
                }
                if (this.isInstanceOf(element, "mediation", "http://purl.org/net/sword/")) {
                    this.setMediation(this.unmarshallBoolean(element));
                    continue;
                }
                if (this.isInstanceOf(element, "treatment", "http://purl.org/net/sword/")) {
                    this.treatment = this.unmarshallString(element);
                    continue;
                }
                if (!this.isInstanceOf(element, "namespace", "http://purl.org/net/sword/")) continue;
                this.namespace = this.unmarshallString(element);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Collection: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse an element in Collection", ex);
        }
    }
}

