/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.UnmarshallException;
import org.w3.atom.Entry;

public class SWORDEntry
extends Entry {
    private boolean noOp;
    private String verboseDescription;
    private String treatment;
    private String formatNamespace;
    private boolean noOpSet;

    public boolean isNoOp() {
        return this.noOp;
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
        this.noOpSet = true;
    }

    public boolean isNoOpSet() {
        return this.noOpSet;
    }

    public String getVerboseDescription() {
        return this.verboseDescription;
    }

    public void setVerboseDescription(String verboseDescription) {
        this.verboseDescription = verboseDescription;
    }

    public String getTreatment() {
        return this.treatment;
    }

    public void setTreatment(String treatment) {
        this.treatment = treatment;
    }

    public Element marshall() {
        Element entry = super.marshall();
        if (this.treatment != null) {
            Element treatmentElement = new Element("sword:treatment", "http://purl.org/net/sword/");
            treatmentElement.appendChild(this.treatment);
            entry.appendChild((Node)treatmentElement);
        }
        if (this.formatNamespace != null) {
            Element formatNamespaceElement = new Element("sword:formatNamespace", "http://purl.org/net/sword/");
            formatNamespaceElement.appendChild(this.formatNamespace);
            entry.appendChild((Node)formatNamespaceElement);
        }
        if (this.verboseDescription != null) {
            Element verboseDescriptionElement = new Element("sword:verboseDescription", "http://purl.org/net/sword/");
            verboseDescriptionElement.appendChild(this.verboseDescription);
            entry.appendChild((Node)verboseDescriptionElement);
        }
        if (this.noOpSet) {
            Element noOpElement = new Element("sword:noOp", "http://purl.org/net/sword/");
            noOpElement.appendChild(Boolean.toString(this.noOp));
            entry.appendChild((Node)noOpElement);
        }
        return entry;
    }

    public void unmarshall(Element entry) throws UnmarshallException {
        super.unmarshall(entry);
        try {
            Elements elements = entry.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, "treatment", "http://purl.org/net/sword/")) {
                    this.treatment = this.unmarshallString(element);
                    continue;
                }
                if (this.isInstanceOf(element, "formatNamespace", "http://purl.org/net/sword/")) {
                    this.formatNamespace = this.unmarshallString(element);
                    continue;
                }
                if (this.isInstanceOf(element, "noOp", "http://purl.org/net/sword/")) {
                    this.setNoOp(this.unmarshallBoolean(element));
                    continue;
                }
                if (!this.isInstanceOf(element, "verboseDescription", "http://purl.org/net/sword/")) continue;
                this.verboseDescription = this.unmarshallString(element);
            }
        }
        catch (UnmarshallException ex) {
            InfoLogger.getLogger().writeError("Error parsing SWORDEntry. " + ex.getMessage());
            throw new UnmarshallException("Error parsing SWORD Entry", ex);
        }
    }

    public String getFormatNamespace() {
        return this.formatNamespace;
    }

    public void setFormatNamespace(String formatNamespace) {
        this.formatNamespace = formatNamespace;
    }
}

