/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.purl.sword.base.Collection;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceLevel;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDocument {
    private Service service;

    public ServiceDocument() {
        this(ServiceLevel.ZERO);
    }

    public ServiceDocument(ServiceLevel complianceLevel) {
        this.service = new Service(complianceLevel);
    }

    public ServiceDocument(Service service) {
        this.service = service;
    }

    public ServiceDocument(ServiceLevel complianceLevel, boolean noOp, boolean verbose, String workspaceTitle, Collection workspaceCollections) {
        this.service = new Service(complianceLevel, noOp, verbose);
        Workspace workspace = new Workspace(workspaceTitle);
        workspace.addCollection(workspaceCollections);
        this.service.addWorkspace(workspace);
    }

    public ServiceLevel getComplianceLevel() {
        return this.service.getComplianceLevel();
    }

    public boolean supportsNoOp() {
        return this.service.isNoOp();
    }

    public void setNoOp(boolean noOp) {
        this.service.setNoOp(noOp);
    }

    public boolean supportsVerbose() {
        return this.service.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.service.setVerbose(verbose);
    }

    public Iterator<Collection> getWorkspaceCollections() {
        return null;
    }

    public Iterator<Workspace> getWorkspaces() {
        return this.service.getWorkspaces();
    }

    public void addWorkspace(Workspace workspace) {
        this.service.addWorkspace(workspace);
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public String toString() {
        return this.marshall();
    }

    public String marshall() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)stream, "UTF-8");
            serializer.setIndent(3);
            serializer.setMaxLength(64);
            Document doc = new Document(this.service.marshall());
            serializer.write(doc);
            return stream.toString();
        }
        catch (IOException ex) {
            System.err.println(ex);
            return null;
        }
    }

    public void unmarshall(String xml) throws UnmarshallException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(xml, "http://something.com/here");
            Element root = doc.getRootElement();
            this.service = new Service();
            this.service.unmarshall(root);
        }
        catch (ParsingException ex) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new UnmarshallException("Error acessing the file?", ex);
        }
    }
}

