/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import nu.xom.Element;
import nu.xom.Node;
import org.purl.sword.base.UnmarshallException;

public class XmlElement {
    protected String prefix;
    protected String localName;
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public XmlElement(String localName) {
        this.localName = localName;
    }

    public XmlElement(String prefix, String localName) {
        this.prefix = prefix;
        this.localName = localName;
    }

    protected boolean unmarshallBoolean(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing Boolean Value", null);
        }
        try {
            Node child = element.getChild(0);
            String value = child.getValue();
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new UnmarshallException("Illegal Value");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing Boolean element", ex);
        }
    }

    protected String unmarshallString(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing String Value", null);
        }
        try {
            Node child = element.getChild(0);
            return child.getValue();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing Boolean element", ex);
        }
    }

    protected int unmarshallInteger(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing Integer Value", null);
        }
        try {
            Node child = element.getChild(0);
            return Integer.parseInt(child.getValue());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing Boolean element", ex);
        }
        catch (NumberFormatException nfex) {
            throw new UnmarshallException("Error fomratting the number", nfex);
        }
    }

    protected Date unmarshallDate(Element element) throws UnmarshallException {
        try {
            String content = this.unmarshallString(element);
            return this.stringToDate(content);
        }
        catch (UnmarshallException ue) {
            throw new UnmarshallException("Error accessing the date.", ue);
        }
        catch (ParseException pe) {
            throw new UnmarshallException("Error accessing the date.", pe);
        }
    }

    protected String dateToString(Date date) {
        if (date == null) {
            GregorianCalendar cal = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
            date = cal.getTime();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        return formatter.format(date);
    }

    protected Date stringToDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        return formatter.parse(date);
    }

    protected boolean isInstanceOf(Element element, String localName, String namespaceURI) {
        return localName.equals(element.getLocalName()) && namespaceURI.equals(element.getNamespaceURI());
    }

    public String getQualifiedName() {
        return this.getQualifiedName(this.localName);
    }

    public String getQualifiedName(String name) {
        String p = this.prefix;
        if (p != null) {
            p = p + ":";
        }
        return p + name;
    }
}

