/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceDocumentRequest;
import org.purl.sword.server.SWORDServer;

public class ServiceDocumentServlet
extends HttpServlet {
    private SWORDServer myRepository;
    private String authN;
    private static Logger log = Logger.getLogger(ServiceDocumentServlet.class);

    public void init() {
        String className = this.getServletContext().getInitParameter("sword-server-class");
        if (className == null) {
            log.fatal((Object)"Unable to read value of 'sword-server-class' from Servlet context");
        } else {
            try {
                this.myRepository = (SWORDServer)Class.forName(className).newInstance();
                log.info((Object)("Using " + className + " as the SWORDServer"));
            }
            catch (Exception e) {
                log.fatal((Object)("Unable to instantiate class from 'sword-server-class': " + className));
            }
        }
        this.authN = this.getServletContext().getInitParameter("authentication-method");
        if (this.authN == null || this.authN == "") {
            this.authN = "None";
        }
        log.info((Object)("Authentication type set to: " + this.authN));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceDocumentRequest sdr = new ServiceDocumentRequest();
        String usernamePassword = this.getUsernamePassword(request);
        if (usernamePassword != null && !usernamePassword.equals("")) {
            int p = usernamePassword.indexOf(":");
            if (p != -1) {
                sdr.setUsername(usernamePassword.substring(0, p));
                sdr.setPassword(usernamePassword.substring(p + 1));
            }
        } else if (this.authenticateWithBasic()) {
            String s = "Basic realm=\"SWORD\"";
            response.setHeader("WWW-Authenticate", s);
            response.setStatus(401);
            return;
        }
        sdr.setOnBehalfOf(request.getHeader("X-On-Behalf-Of".toString()));
        sdr.setIPAddress(request.getRemoteAddr());
        try {
            ServiceDocument sd = this.myRepository.doServiceDocument(sdr);
            response.setContentType("application/atomsvc+xml; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.write(sd.marshall());
            out.flush();
        }
        catch (SWORDAuthenticationException sae) {
            if (this.authN.equals("Basic")) {
                String s = "Basic realm=\"SWORD\"";
                response.setHeader("WWW-Authenticate", s);
                response.setStatus(401);
            }
        }
        catch (SWORDException se) {
            response.sendError(500);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(501);
    }

    private String getUsernamePassword(HttpServletRequest request) {
        try {
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                String userPass = new String(Base64.decodeBase64((byte[])credentials.getBytes()));
                return userPass;
            }
        }
        catch (Exception e) {
            log.debug((Object)e.toString());
        }
        return null;
    }

    private boolean authenticateWithBasic() {
        return this.authN.equalsIgnoreCase("Basic");
    }
}

