/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.Author;
import org.w3.atom.Content;
import org.w3.atom.Contributor;
import org.w3.atom.Link;
import org.w3.atom.Rights;
import org.w3.atom.Source;
import org.w3.atom.Summary;
import org.w3.atom.Title;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
extends XmlElement
implements SwordElementInterface {
    private List<Author> authors = new ArrayList<Author>();
    private List<String> categories = new ArrayList<String>();
    private Content content;
    private List<Contributor> contributors = new ArrayList<Contributor>();
    private String id;
    private List<Link> links = new ArrayList<Link>();
    private Date published;
    private Rights rights;
    private Source source;
    private Summary summary;
    private Title title;
    private Date updated;

    public Entry() {
        super("atom", "entry");
    }

    @Override
    public Element marshall() {
        Element entry = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        entry.addNamespaceDeclaration("sword", "http://purl.org/net/sword/");
        entry.addNamespaceDeclaration("atom", "http://www.w3.org/2005/Atom");
        if (this.id != null) {
            Element idElement = new Element(this.getQualifiedName("id"), "http://www.w3.org/2005/Atom");
            idElement.appendChild(this.id);
            entry.appendChild((Node)idElement);
        }
        for (Author author : this.authors) {
            entry.appendChild((Node)author.marshall());
        }
        if (this.content != null) {
            entry.appendChild((Node)this.content.marshall());
        }
        for (Contributor contributor : this.contributors) {
            entry.appendChild((Node)contributor.marshall());
        }
        for (Link link : this.links) {
            entry.appendChild((Node)link.marshall());
        }
        if (this.published != null) {
            Element publishedElement = new Element(this.getQualifiedName("published"), "http://www.w3.org/2005/Atom");
            publishedElement.appendChild(this.dateToString(this.published));
            entry.appendChild((Node)publishedElement);
        }
        if (this.rights != null) {
            entry.appendChild((Node)this.rights.marshall());
        }
        if (this.summary != null) {
            entry.appendChild((Node)this.summary.marshall());
        }
        if (this.title != null) {
            entry.appendChild((Node)this.title.marshall());
        }
        if (this.source != null) {
            entry.appendChild((Node)this.source.marshall());
        }
        if (this.updated != null) {
            Element updatedElement = new Element(this.getQualifiedName("updated"), "http://www.w3.org/2005/Atom");
            updatedElement.appendChild(this.dateToString(this.updated));
            entry.appendChild((Node)updatedElement);
        }
        Element categoryElement = null;
        for (String category : this.categories) {
            categoryElement = new Element(this.getQualifiedName("category"), "http://www.w3.org/2005/Atom");
            categoryElement.appendChild(category);
            entry.appendChild((Node)categoryElement);
        }
        return entry;
    }

    @Override
    public void unmarshall(Element entry) throws UnmarshallException {
        if (!this.isInstanceOf(entry, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Not a " + this.getQualifiedName() + " element");
        }
        try {
            this.authors.clear();
            this.categories.clear();
            this.contributors.clear();
            this.links.clear();
            Elements elements = entry.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, "author", "http://www.w3.org/2005/Atom")) {
                    Author author = new Author();
                    author.unmarshall(element);
                    this.authors.add(author);
                    continue;
                }
                if (this.isInstanceOf(element, "category", "http://www.w3.org/2005/Atom")) {
                    this.categories.add(this.unmarshallString(element));
                    continue;
                }
                if (this.isInstanceOf(element, "content", "http://www.w3.org/2005/Atom")) {
                    this.content = new Content();
                    this.content.unmarshall(element);
                    continue;
                }
                if (this.isInstanceOf(element, "contributor", "http://www.w3.org/2005/Atom")) {
                    Contributor contributor = new Contributor();
                    contributor.unmarshall(element);
                    this.contributors.add(contributor);
                    continue;
                }
                if (this.isInstanceOf(element, "id", "http://www.w3.org/2005/Atom")) {
                    this.id = this.unmarshallString(element);
                    continue;
                }
                if (this.isInstanceOf(element, "link", "http://www.w3.org/2005/Atom")) {
                    Link link = new Link();
                    link.unmarshall(element);
                    this.links.add(link);
                    continue;
                }
                if (this.isInstanceOf(element, "published", "http://www.w3.org/2005/Atom")) {
                    this.published = this.unmarshallDate(element);
                    continue;
                }
                if (this.isInstanceOf(element, "rights", "http://www.w3.org/2005/Atom")) {
                    this.rights = new Rights();
                    this.rights.unmarshall(element);
                    continue;
                }
                if (this.isInstanceOf(element, "summary", "http://www.w3.org/2005/Atom")) {
                    this.summary = new Summary();
                    this.summary.unmarshall(element);
                    continue;
                }
                if (this.isInstanceOf(element, "title", "http://www.w3.org/2005/Atom")) {
                    this.title = new Title();
                    this.title.unmarshall(element);
                    continue;
                }
                if (this.isInstanceOf(element, "updated", "http://www.w3.org/2005/Atom")) {
                    this.updated = this.unmarshallDate(element);
                    continue;
                }
                if (!this.isInstanceOf(element, "source", "http://www.w3.org/2005/Atom")) continue;
                this.source = new Source();
                this.source.unmarshall(element);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Entry: " + ex.getMessage());
            ex.printStackTrace();
            throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
        }
    }

    public Iterator<Author> getAuthors() {
        return this.authors.iterator();
    }

    public void addAuthors(Author author) {
        this.authors.add(author);
    }

    public void clearAuthors() {
        this.authors.clear();
    }

    public Iterator<String> getCategories() {
        return this.categories.iterator();
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void clearCategories() {
        this.categories.clear();
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Iterator<Contributor> getContributors() {
        return this.contributors.iterator();
    }

    public void addContributor(Contributor contributor) {
        this.contributors.add(contributor);
    }

    public void clearContributors() {
        this.contributors.clear();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Iterator<Link> getLinks() {
        return this.links.iterator();
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void clearLinks() {
        this.links.clear();
    }

    public String getPublished() {
        return this.dateToString(this.published);
    }

    public void setPublished(String published) throws ParseException {
        this.published = this.stringToDate(published);
    }

    public Rights getRights() {
        return this.rights;
    }

    public void setRights(Rights rights) {
        this.rights = rights;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public String getUpdated() {
        return this.dateToString(this.updated);
    }

    public void setUpdated(String updated) throws ParseException {
        this.updated = this.stringToDate(updated);
    }
}

